package com.ptteng.fans.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.fans.common.model.Contents;
import com.ptteng.fans.common.service.ContentsService;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


public class ContentsServiceImpl extends BaseDaoServiceImpl implements ContentsService {

 

	private static final Log log = LogFactory.getLog(ContentsServiceImpl.class);



		   
		@Override
		public Long insert(Contents contents)throws ServiceException, ServiceDaoException{
		
	
		          
    log.info(" insert data : " + contents);

		if (contents == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		contents.setCreateAt(currentTimeMillis);
		contents.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(contents);
		} catch (DaoException e) {
			log.error(" insert wrong : " + contents);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert data success : " + result);
    
return result;	
		}	
		  
    	   
		@Override
		public List<Contents> insertList(List<Contents> contentsList)throws ServiceException, ServiceDaoException{
		
	
		          	
        log.info(" insert lists : " + (contentsList == null ? "null" : contentsList.size()));
      
		List<Contents> resultList = null;

		if (CollectionUtils.isEmpty(contentsList)) {
			return new ArrayList<Contents>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Contents contents : contentsList) {
			contents.setCreateAt(currentTimeMillis);
			contents.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Contents>) dao.batchSave(contentsList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + contentsList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));
    
		return resultList;
		
		
			
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
	
		            
	    log.info(" delete data : " + id);
 
		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Contents.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
 
		log.info(" delete data success : " + id);
   
		return result;
		
		}	
		  
    	   
		@Override
		public boolean update(Contents contents)throws ServiceException, ServiceDaoException{
		
	
		          
	log.info(" update data : " + (contents == null ? "null" : contents.getId()));

		boolean result = false;

		if (contents == null) {
			return true;
		}

		contents.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(contents);
		} catch (DaoException e) {
			log.error(" update wrong : " + contents);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + contents);
       }
		return result;	
		}	
		  
    	   
		@Override
		public boolean updateList(List<Contents> contentsList)throws ServiceException, ServiceDaoException{
		
	
		          log.info(" update lists : " + (contentsList == null ? "null" : contentsList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(contentsList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Contents contents : contentsList) {
			contents.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(contentsList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + contentsList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" update lists success : " + contentsList.size());
         
		return result;	
		}	
		  
    	   
		@Override
		public Contents getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
	
		              
        log.info(" get data : " + id);
      
		Contents contents = null;

		if (id == null) {
			return contents;
		}

		try {
			contents = (Contents) dao.get(Contents.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
     
		log.info(" get data success : " + id);
      
		return contents;		
		}	
		  
    	   
		@Override
		public List<Contents> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
	
		          	  
	    log.info(" get lists : " + (ids == null ? "null" : ids));
     
		List<Contents> contents = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Contents>();
		}

		try {
			contents = (List<Contents>) dao.getList(Contents.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
    
		log.info(" get data success : " + (contents == null ? "null" : contents.size()));
    
		return contents;	
		}	
		  
    	
		
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getContentsIdsByMerchantId(Long merchantId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by merchantId,start,limit  : " + merchantId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getContentsIdsByMerchantId", new Object[] { merchantId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by merchantId,start,limit)  : " + merchantId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getContentsIdsByType(Integer type,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by type,start,limit  : " + type+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getContentsIdsByType", new Object[] { type},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by type,start,limit)  : " + type+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getContentsIdsByTypeAndMerchantIdOrderBySort(Integer type,Long merchantId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" get ids by type,merchantId,start,limit  : " + type+" , "+merchantId+" , "+start+" , "+limit );
	  }
	 	List<Long> idList = null;
        
        // TODO 参数检查!

        if (start == null) {
            start = 0;
        }

        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }

	try {
		idList = dao.getIdList("getContentsIdsByTypeAndMerchantIdOrderBySort", new Object[] { type,merchantId},start,limit, false);

   
   } catch (DaoException e) {
			log.error(" get ids  wrong by type,merchantId,start,limit)  : " + type+" , "+merchantId+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
   log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
  }
		return idList;
		
	
	
	}
	
		
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countContentsIdsByMerchantId(Long merchantId)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by merchantId  : " + merchantId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getContentsIdsByMerchantId", new Object[] { merchantId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by merchantId)  : " + merchantId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countContentsIdsByType(Integer type)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by type  : " + type );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getContentsIdsByType", new Object[] { type});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by type)  : " + type );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countContentsIdsByTypeAndMerchantIdOrderBySort(Integer type,Long merchantId)throws ServiceException, ServiceDaoException{
		
		       if(log.isInfoEnabled()){
      log.info(" count ids by type,merchantId  : " + type+" , "+merchantId );
	  }
	 	Integer count=null;
        
       

	try {
	   
		count = dao.count("getContentsIdsByTypeAndMerchantIdOrderBySort", new Object[] { type,merchantId});

   
   } catch (DaoException e) {
			log.error(" count ids  wrong by type,merchantId)  : " + type+" , "+merchantId );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
  if(log.isInfoEnabled()){
    log.info(" count  success : " + count);
  }
		return count;
		
	
	
	}
	
		
	
	
	
		
	@Override
	public List<Long> getContentsIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		
		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;
		
		
		
		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}
		
		try {
			idList = dao.getIdList("getContentsIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}
	
	
		@Override
	public Integer countContentsIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getContentsIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getContentsIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}

}

