package com.ptteng.fans.common.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import com.ptteng.fans.common.model.Classify;
import com.ptteng.fans.common.service.ClassifyService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.ArrayList;
import java.util.List;


public class ClassifyServiceImpl extends BaseDaoServiceImpl implements ClassifyService {



	private static final Log log = LogFactory.getLog(ClassifyServiceImpl.class);




		@Override
		public Long insert(Classify classify)throws ServiceException, ServiceDaoException{



    log.info(" insert data : " + classify);

		if (classify == null) {
			return null;
		}

		long currentTimeMillis = System.currentTimeMillis();
		classify.setCreateAt(currentTimeMillis);
		classify.setUpdateAt(currentTimeMillis);

		Long result = null;
		try {
			result = (Long) dao.save(classify);
		} catch (DaoException e) {
			log.error(" insert wrong : " + classify);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert data success : " + result);

return result;
		}


		@Override
		public List<Classify> insertList(List<Classify> classifyList)throws ServiceException, ServiceDaoException{



        log.info(" insert lists : " + (classifyList == null ? "null" : classifyList.size()));

		List<Classify> resultList = null;

		if (CollectionUtils.isEmpty(classifyList)) {
			return new ArrayList<Classify>();
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Classify classify : classifyList) {
			classify.setCreateAt(currentTimeMillis);
			classify.setUpdateAt(currentTimeMillis);
		}

		try {
			resultList = (List<Classify>) dao.batchSave(classifyList);
		} catch (DaoException e) {
			log.error(" insert list wrong : " + classifyList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" insert lists  success : " + (resultList == null ? "null" : resultList.size()));

		return resultList;



		}


		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{



	    log.info(" delete data : " + id);

		boolean result = false;

		if (id == null) {
			return true;
		}

		try {
			result = dao.delete(Classify.class, id);
		} catch (DaoException e) {
			log.error(" delete wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" delete data success : " + id);

		return result;

		}


		@Override
		public boolean update(Classify classify)throws ServiceException, ServiceDaoException{



	log.info(" update data : " + (classify == null ? "null" : classify.getId()));

		boolean result = false;

		if (classify == null) {
			return true;
		}

		classify.setUpdateAt(System.currentTimeMillis());

		try {
			result = dao.update(classify);
		} catch (DaoException e) {
			log.error(" update wrong : " + classify);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
       if(log.isInfoEnabled()){
		log.info(" update data success : " + classify);
       }
		return result;
		}


		@Override
		public boolean updateList(List<Classify> classifyList)throws ServiceException, ServiceDaoException{


		          log.info(" update lists : " + (classifyList == null ? "null" : classifyList.size()));

		boolean result = false;

		if (CollectionUtils.isEmpty(classifyList)) {
			return true;
		}

		long currentTimeMillis = System.currentTimeMillis();
		for (Classify classify : classifyList) {
			classify.setUpdateAt(currentTimeMillis);
		}

		try {
			result = dao.batchUpdate(classifyList);
		} catch (DaoException e) {
			log.error(" update list wrong : " + classifyList);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" update lists success : " + classifyList.size());

		return result;
		}


		@Override
		public Classify getObjectById(Long id)throws ServiceException, ServiceDaoException{



        log.info(" get data : " + id);

		Classify classify = null;

		if (id == null) {
			return classify;
		}

		try {
			classify = (Classify) dao.get(Classify.class, id);
		} catch (DaoException e) {
			log.error(" get wrong : " + id);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + id);

		return classify;
		}


		@Override
		public List<Classify> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{



	    log.info(" get lists : " + (ids == null ? "null" : ids));

		List<Classify> classify = null;

		if (CollectionUtils.isEmpty(ids)) {
			return new ArrayList<Classify>();
		}

		try {
			classify = (List<Classify>) dao.getList(Classify.class, ids);
		} catch (DaoException e) {
			log.error(" get wrong : " + ids);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}

		log.info(" get data success : " + (classify == null ? "null" : classify.size()));

		return classify;
		}












	@Override
	public List<Long> getClassifyIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		log.info(" get ids   by start,limit  ================== " + start + " , " + limit);
		List<Long> idList = null;



		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getClassifyIdsAll",new Object[] {},start, limit, false);
		} catch (DaoException e) {
			log.error(" get ids  wrong by start,limit)  : " + start + " , " + limit);
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" get ids success == : " + (idList == null ? "null" : idList.size()));
		}
		return idList;
	}


		@Override
	public Integer countClassifyIds() throws ServiceException,
			ServiceDaoException {
		Integer count =  0;
		try {
			count = dao.count("getClassifyIdsAll",new Object[] {});
		} catch (DaoException e) {
			log.error(" count by getClassifyIds " ) ;
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if (log.isInfoEnabled()) {
			log.info(" count  : " + count);
		}
		return count;
	}


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public Integer  countClassifyIdsByStatus(Long status)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" count ids by status  : " + status );
		}
		Integer count=null;



		try {

			count = dao.count("getClassifyIdsByStatus", new Object[] { status});


		} catch (DaoException e) {
			log.error(" count ids  wrong by status)  : " + status );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" count  success : " + count);
		}
		return count;



	}

	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	@Override
	public List<Long>  getClassifyIdsByStatus(Long status,Integer start,Integer limit)throws ServiceException, ServiceDaoException{

		if(log.isInfoEnabled()){
			log.info(" get ids by status,start,limit  : " + status+" , "+start+" , "+limit );
		}
		List<Long> idList = null;

		// TODO 参数检查!

		if (start == null) {
			start = 0;
		}

		if (limit == null) {
			limit = Integer.MAX_VALUE;
		}

		try {
			idList = dao.getIdList("getClassifyIdsByStatus", new Object[] { status},start,limit, false);


		} catch (DaoException e) {
			log.error(" get ids  wrong by status,start,limit)  : " + status+" , "+start+" , "+limit );
			log.error(e);
			e.printStackTrace();
			throw new ServiceDaoException(e);
		}
		if(log.isInfoEnabled()){
			log.info(" get ids success : " + (idList == null ? "null" : idList.size()));
		}
		return idList;



	}






}

