/**
 *
 */
package com.ptteng.sca.fans.common.client;

import java.util.List;
import java.util.Map;

import com.ptteng.fans.common.model.BaseClassify;
import com.ptteng.fans.common.service.BaseClassifyService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class BaseClassifySCAClient implements BaseClassifyService {

  private BaseClassifyService baseClassifyService;

  public BaseClassifyService getBaseClassifyService() {
    return baseClassifyService;
  }


  public void setBaseClassifyService(BaseClassifyService baseClassifyService) {
    this.baseClassifyService = baseClassifyService;
  }


  @Override
  public Long insert(BaseClassify baseClassify,String lang) throws Exception {

    return baseClassifyService.insert(baseClassify,lang);


  }


  @Override
  public List<BaseClassify> insertList(List<BaseClassify> baseClassifyList,String lang)
      throws Exception {

    return baseClassifyService.insertList(baseClassifyList,lang);


  }


  @Override
  public boolean delete(Long id,String lang) throws Exception {

    return baseClassifyService.delete(id,lang);


  }


  @Override
  public boolean update(BaseClassify baseClassify,String lang) throws Exception {

    return baseClassifyService.update(baseClassify,lang);


  }


  @Override
  public boolean updateList(List<BaseClassify> baseClassifyList,String lang)
      throws Exception {

    return baseClassifyService.updateList(baseClassifyList,lang);


  }


  @Override
  public BaseClassify getObjectById(Long id,String lang) throws Exception {

    return baseClassifyService.getObjectById(id,lang);


  }


  @Override
  public List<BaseClassify> getObjectsByIds(List<Long> ids,String lang)
      throws Exception {

    return baseClassifyService.getObjectsByIds(ids,lang);


  }


  /**
   *
   * @param
   * @return
   * @throws ServiceException
   * @throws ServiceDaoException
   */
  @Override
  public List<Long> getBaseClassifyIdsByTypeAndMerchantIdOrderBySort(Integer type, Long merchantId,
      Integer start, Integer limit) throws ServiceException, ServiceDaoException {

    return baseClassifyService
        .getBaseClassifyIdsByTypeAndMerchantIdOrderBySort(type, merchantId, start, limit);


  }


  /**
   *
   * @param
   * @return
   * @throws ServiceException
   * @throws ServiceDaoException
   */
  @Override
  public List<Long> getBaseClassifyIdsByType(Integer type, Integer start, Integer limit)
      throws ServiceException, ServiceDaoException {

    return baseClassifyService.getBaseClassifyIdsByType(type, start, limit);


  }


  /**
   *
   * @param
   * @return
   * @throws ServiceException
   * @throws ServiceDaoException
   */
  @Override
  public List<Long> getBaseClassifyIdsByMerchantId(Long merchantId, Integer start, Integer limit)
      throws ServiceException, ServiceDaoException {

    return baseClassifyService.getBaseClassifyIdsByMerchantId(merchantId, start, limit);


  }


  /**
   *
   * @param
   * @return
   * @throws ServiceException
   * @throws ServiceDaoException
   */
  @Override
  public Integer countBaseClassifyIdsByTypeAndMerchantIdOrderBySort(Integer type, Long merchantId)
      throws ServiceException, ServiceDaoException {

    return baseClassifyService.countBaseClassifyIdsByTypeAndMerchantIdOrderBySort(type, merchantId);


  }


  /**
   *
   * @param
   * @return
   * @throws ServiceException
   * @throws ServiceDaoException
   */
  @Override
  public Integer countBaseClassifyIdsByType(Integer type)
      throws ServiceException, ServiceDaoException {

    return baseClassifyService.countBaseClassifyIdsByType(type);


  }


  /**
   *
   * @param
   * @return
   * @throws ServiceException
   * @throws ServiceDaoException
   */
  @Override
  public Integer countBaseClassifyIdsByMerchantId(Long merchantId)
      throws ServiceException, ServiceDaoException {

    return baseClassifyService.countBaseClassifyIdsByMerchantId(merchantId);


  }


  @Override
  public List<Long> getBaseClassifyIds(Integer start, Integer limit)
      throws ServiceException, ServiceDaoException {
    // TODO Auto-generated method stub
    return baseClassifyService.getBaseClassifyIds(start, limit);
  }

  @Override
  public Integer countBaseClassifyIds() throws ServiceException, ServiceDaoException {
    // TODO Auto-generated method stub
    return baseClassifyService.countBaseClassifyIds();
  }


  @Override
  public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions,
      Integer start, Integer limit)
      throws ServiceException, ServiceDaoException {
    // TODO Auto-generated method stub
    return baseClassifyService.getIdsByDynamicCondition(clz, conditions, start, limit);
  }


  @Override
  public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
    // TODO Auto-generated method stub
    return baseClassifyService.fakeDelete(clz, id);
  }


  @Override
  public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
    baseClassifyService.deleteList(clz, ids);

  }

  @Override
  public Object getObjectByDynamicCondition(Class clz,
      Map<String, Object> conditions, Integer start, Integer limit)
      throws ServiceException, ServiceDaoException {

    return this.baseClassifyService.getObjectByDynamicCondition(clz, conditions, start, limit);
  }

    @Override
    public Object getMapListByDynamicCondition(Class clz,
                                                  Map<String, Object> conditions, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return  this.baseClassifyService.getMapListByDynamicCondition(clz, conditions, start, limit);
    }


}

