package com.ptteng.fans.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.fans.common.model.Contents;
import java.util.List;
import org.osoa.sca.annotations.Remotable;

@Remotable
public interface ContentsService extends BaseDaoService {

	



   		   
		
		public Long insert(Contents contents,String lang) throws ServiceException, ServiceDaoException, IllegalAccessException, InstantiationException, ClassNotFoundException;


    	   
		
		public List<Contents> insertList(List<Contents> contentsList,String lang)throws Exception;


    	   
		
		public boolean delete(Long id,String lang) throws ServiceException, ServiceDaoException, IllegalAccessException, InstantiationException, ClassNotFoundException;

    	   
		
		public boolean update(Contents contents,String lang) throws ServiceException, ServiceDaoException, IllegalAccessException, InstantiationException, ClassNotFoundException;


    	   
		
		public boolean updateList(List<Contents> contentsList,String lang) throws ServiceException, ServiceDaoException, IllegalAccessException, InstantiationException, ClassNotFoundException;

    	   
		
		public Contents getObjectById(Long id,String lang) throws ServiceException, ServiceDaoException, IllegalAccessException, InstantiationException, ClassNotFoundException;

		
		public List<Contents> getObjectsByIds(List<Long> ids,String lang) throws ServiceException, ServiceDaoException, IllegalAccessException, InstantiationException, ClassNotFoundException;


    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countContentsIdsByMerchantId(Long merchantId)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countContentsIdsByType(Integer type)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countContentsIdsByTypeAndMerchantIdOrderBySort(Integer type,Long merchantId)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getContentsIdsByMerchantId(Long merchantId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getContentsIdsByType(Integer type, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getContentsIdsByTypeAndMerchantIdOrderBySort(Integer type,Long merchantId,
      Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getContentsIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countContentsIds() throws ServiceException, ServiceDaoException;
	

}

