package com.ptteng.fans.common.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.fans.common.model.ContentsInfo;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface ContentsInfoService extends BaseDaoService {


    public Long insert(ContentsInfo contentsInfo) throws ServiceException, ServiceDaoException;


    public List<ContentsInfo> insertList(List<ContentsInfo> contentsInfoList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(ContentsInfo contentsInfo) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<ContentsInfo> contentsInfoList) throws ServiceException, ServiceDaoException;


    public ContentsInfo getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<ContentsInfo> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getContentsInfoIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countContentsInfoIds() throws ServiceException, ServiceDaoException;


}

