/**
 *
 */
package com.ptteng.sca.employment.common.client;

import java.util.List;
import java.util.Map;

import com.ptteng.employment.common.model.ServiceProvider;
import com.ptteng.employment.common.service.ServiceProviderService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class ServiceProviderSCAClient implements ServiceProviderService {

    private ServiceProviderService serviceProviderService;

    public ServiceProviderService getServiceProviderService() {
        return serviceProviderService;
    }


    public void setServiceProviderService(ServiceProviderService serviceProviderService) {
        this.serviceProviderService = serviceProviderService;
    }


    @Override
    public Long insert(ServiceProvider serviceProvider) throws ServiceException, ServiceDaoException {

        return serviceProviderService.insert(serviceProvider);


    }


    @Override
    public List<ServiceProvider> insertList(List<ServiceProvider> serviceProviderList) throws ServiceException, ServiceDaoException {

        return serviceProviderService.insertList(serviceProviderList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return serviceProviderService.delete(id);


    }


    @Override
    public boolean update(ServiceProvider serviceProvider) throws ServiceException, ServiceDaoException {

        return serviceProviderService.update(serviceProvider);


    }


    @Override
    public boolean updateList(List<ServiceProvider> serviceProviderList) throws ServiceException, ServiceDaoException {

        return serviceProviderService.updateList(serviceProviderList);


    }


    @Override
    public ServiceProvider getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return serviceProviderService.getObjectById(id);


    }


    @Override
    public List<ServiceProvider> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return serviceProviderService.getObjectsByIds(ids);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getServiceProviderIdByCreditCode(String creditCode) throws ServiceException, ServiceDaoException {

        return serviceProviderService.getServiceProviderIdByCreditCode(creditCode);


    }


    @Override
    public List<Long> getServiceProviderIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return serviceProviderService.getServiceProviderIds(start, limit);
    }

    @Override
    public Integer countServiceProviderIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return serviceProviderService.countServiceProviderIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return serviceProviderService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return serviceProviderService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        serviceProviderService.deleteList(clz, ids);

    }

    @Override
    public Object getObjectByDynamicCondition(Class clz,
                                              Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.serviceProviderService.getObjectByDynamicCondition(clz, conditions, start, limit);
    }

    @Override
    public Object getMapListByDynamicCondition(Class clz,
                                               Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.serviceProviderService.getMapListByDynamicCondition(clz, conditions, start, limit);
    }


}

