/**
 *
 */
package com.ptteng.sca.employment.common.client;

import java.util.List;
import java.util.Map;

import com.ptteng.employment.common.model.ProjectUser;
import com.ptteng.employment.common.service.ProjectUserService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class ProjectUserSCAClient implements ProjectUserService {

    private ProjectUserService projectUserService;

    public ProjectUserService getProjectUserService() {
        return projectUserService;
    }


    public void setProjectUserService(ProjectUserService projectUserService) {
        this.projectUserService = projectUserService;
    }


    @Override
    public Long insert(ProjectUser projectUser) throws ServiceException, ServiceDaoException {

        return projectUserService.insert(projectUser);


    }


    @Override
    public List<ProjectUser> insertList(List<ProjectUser> projectUserList) throws ServiceException, ServiceDaoException {

        return projectUserService.insertList(projectUserList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return projectUserService.delete(id);


    }


    @Override
    public boolean update(ProjectUser projectUser) throws ServiceException, ServiceDaoException {

        return projectUserService.update(projectUser);


    }


    @Override
    public boolean updateList(List<ProjectUser> projectUserList) throws ServiceException, ServiceDaoException {

        return projectUserService.updateList(projectUserList);


    }


    @Override
    public ProjectUser getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return projectUserService.getObjectById(id);


    }


    @Override
    public List<ProjectUser> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return projectUserService.getObjectsByIds(ids);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getProjectUserIdByProjectIdAndUserId(Long projectId, Long userId) throws ServiceException, ServiceDaoException {

        return projectUserService.getProjectUserIdByProjectIdAndUserId(projectId, userId);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getProjectUserIdsByProjectId(Long projectId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return projectUserService.getProjectUserIdsByProjectId(projectId, start, limit);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countProjectUserIdsByProjectId(Long projectId) throws ServiceException, ServiceDaoException {

        return projectUserService.countProjectUserIdsByProjectId(projectId);


    }


    @Override
    public List<Long> getProjectUserIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return projectUserService.getProjectUserIds(start, limit);
    }

    @Override
    public Integer countProjectUserIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return projectUserService.countProjectUserIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return projectUserService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return projectUserService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        projectUserService.deleteList(clz, ids);

    }

    @Override
    public Object getObjectByDynamicCondition(Class clz,
                                              Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.projectUserService.getObjectByDynamicCondition(clz, conditions, start, limit);
    }

    @Override
    public Object getMapListByDynamicCondition(Class clz,
                                               Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.projectUserService.getMapListByDynamicCondition(clz, conditions, start, limit);
    }


}

