/**
 *
 */
package com.ptteng.sca.employment.common.client;

import java.util.List;
import java.util.Map;

import com.ptteng.employment.common.model.Project;
import com.ptteng.employment.common.service.ProjectService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class ProjectSCAClient implements ProjectService {

    private ProjectService projectService;

    public ProjectService getProjectService() {
        return projectService;
    }


    public void setProjectService(ProjectService projectService) {
        this.projectService = projectService;
    }


    @Override
    public Long insert(Project project) throws ServiceException, ServiceDaoException {

        return projectService.insert(project);


    }


    @Override
    public List<Project> insertList(List<Project> projectList) throws ServiceException, ServiceDaoException {

        return projectService.insertList(projectList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return projectService.delete(id);


    }


    @Override
    public boolean update(Project project) throws ServiceException, ServiceDaoException {

        return projectService.update(project);


    }


    @Override
    public boolean updateList(List<Project> projectList) throws ServiceException, ServiceDaoException {

        return projectService.updateList(projectList);


    }


    @Override
    public Project getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return projectService.getObjectById(id);


    }


    @Override
    public List<Project> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return projectService.getObjectsByIds(ids);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getProjectIdByProjectCode(String projectCode) throws ServiceException, ServiceDaoException {

        return projectService.getProjectIdByProjectCode(projectCode);


    }

    @Override
    public Long getProjectIdByOrderUUID(String orderUUID) throws ServiceException, ServiceDaoException {
        return projectService.getProjectIdByOrderUUID(orderUUID);
    }

    @Override
    public Integer checkProjectStatus(Long projectId) throws Exception {
        return projectService.checkProjectStatus(projectId);
    }


    @Override
    public List<Long> getProjectIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return projectService.getProjectIds(start, limit);
    }

    @Override
    public Integer countProjectIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return projectService.countProjectIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return projectService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return projectService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        projectService.deleteList(clz, ids);

    }

    @Override
    public Object getObjectByDynamicCondition(Class clz,
                                              Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.projectService.getObjectByDynamicCondition(clz, conditions, start, limit);
    }

    @Override
    public Object getMapListByDynamicCondition(Class clz,
                                               Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.projectService.getMapListByDynamicCondition(clz, conditions, start, limit);
    }


}

