/**
 *
 */
package com.ptteng.sca.employment.common.client;

import java.util.List;
import java.util.Map;

import com.ptteng.employment.common.model.Invoice;
import com.ptteng.employment.common.service.InvoiceService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.sleepycat.je.tree.IN;

public class InvoiceSCAClient implements InvoiceService {

    private InvoiceService invoiceService;

    public InvoiceService getInvoiceService() {
        return invoiceService;
    }


    public void setInvoiceService(InvoiceService invoiceService) {
        this.invoiceService = invoiceService;
    }


    @Override
    public Long insert(Invoice invoice) throws ServiceException, ServiceDaoException {

        return invoiceService.insert(invoice);


    }


    @Override
    public List<Invoice> insertList(List<Invoice> invoiceList) throws ServiceException, ServiceDaoException {

        return invoiceService.insertList(invoiceList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return invoiceService.delete(id);


    }


    @Override
    public boolean update(Invoice invoice) throws ServiceException, ServiceDaoException {

        return invoiceService.update(invoice);


    }


    @Override
    public boolean updateList(List<Invoice> invoiceList) throws ServiceException, ServiceDaoException {

        return invoiceService.updateList(invoiceList);


    }


    @Override
    public Invoice getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return invoiceService.getObjectById(id);


    }


    @Override
    public List<Invoice> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return invoiceService.getObjectsByIds(ids);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getInvoiceIdsByCustomerId(Long customerId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return invoiceService.getInvoiceIdsByCustomerId(customerId, start, limit);


    }

    @Override
    public List<Long> getInvoiceIdsByInvoiceOrderId(Long invoiceOrderId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return invoiceService.getInvoiceIdsByInvoiceOrderId(invoiceOrderId, start, limit);
    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countInvoiceIdsByCustomerId(Long customerId) throws ServiceException, ServiceDaoException {

        return invoiceService.countInvoiceIdsByCustomerId(customerId);


    }


    @Override
    public List<Long> getInvoiceIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return invoiceService.getInvoiceIds(start, limit);
    }

    @Override
    public Integer countInvoiceIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return invoiceService.countInvoiceIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return invoiceService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return invoiceService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        invoiceService.deleteList(clz, ids);

    }

    @Override
    public Object getObjectByDynamicCondition(Class clz,
                                              Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.invoiceService.getObjectByDynamicCondition(clz, conditions, start, limit);
    }

    @Override
    public Object getMapListByDynamicCondition(Class clz,
                                               Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.invoiceService.getMapListByDynamicCondition(clz, conditions, start, limit);
    }


}

