/**
 *
 */
package com.ptteng.sca.employment.common.client;

import java.util.List;
import java.util.Map;

import com.ptteng.employment.common.model.Earning;
import com.ptteng.employment.common.service.EarningService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class EarningSCAClient implements EarningService {

    private EarningService earningService;

    public EarningService getEarningService() {
        return earningService;
    }


    public void setEarningService(EarningService earningService) {
        this.earningService = earningService;
    }


    @Override
    public Long insert(Earning earning) throws ServiceException, ServiceDaoException {

        return earningService.insert(earning);


    }


    @Override
    public List<Earning> insertList(List<Earning> earningList) throws ServiceException, ServiceDaoException {

        return earningService.insertList(earningList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return earningService.delete(id);


    }


    @Override
    public boolean update(Earning earning) throws ServiceException, ServiceDaoException {

        return earningService.update(earning);


    }


    @Override
    public boolean updateList(List<Earning> earningList) throws ServiceException, ServiceDaoException {

        return earningService.updateList(earningList);


    }


    @Override
    public Earning getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return earningService.getObjectById(id);


    }


    @Override
    public List<Earning> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return earningService.getObjectsByIds(ids);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getEarningIdsByUserId(Long userId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return earningService.getEarningIdsByUserId(userId, start, limit);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getEarningIdByUserIdAndProjectId(Long userId, Long projectId) throws ServiceException, ServiceDaoException {

        return earningService.getEarningIdByUserIdAndProjectId(userId, projectId);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countEarningIdsByUserId(Long userId) throws ServiceException, ServiceDaoException {

        return earningService.countEarningIdsByUserId(userId);


    }


    @Override
    public List<Long> getEarningIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return earningService.getEarningIds(start, limit);
    }

    @Override
    public Integer countEarningIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return earningService.countEarningIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return earningService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return earningService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        earningService.deleteList(clz, ids);

    }

    @Override
    public Object getObjectByDynamicCondition(Class clz,
                                              Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.earningService.getObjectByDynamicCondition(clz, conditions, start, limit);
    }

    @Override
    public Object getMapListByDynamicCondition(Class clz,
                                               Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.earningService.getMapListByDynamicCondition(clz, conditions, start, limit);
    }


}

