/**
 *
 */
package com.ptteng.sca.employment.common.client;

import java.util.List;
import java.util.Map;

import com.ptteng.employment.common.model.Contract;
import com.ptteng.employment.common.service.ContractService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class ContractSCAClient implements ContractService {

    private ContractService contractService;

    public ContractService getContractService() {
        return contractService;
    }


    public void setContractService(ContractService contractService) {
        this.contractService = contractService;
    }


    @Override
    public Long insert(Contract contract) throws ServiceException, ServiceDaoException {

        return contractService.insert(contract);


    }


    @Override
    public List<Contract> insertList(List<Contract> contractList) throws ServiceException, ServiceDaoException {

        return contractService.insertList(contractList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return contractService.delete(id);


    }


    @Override
    public boolean update(Contract contract) throws ServiceException, ServiceDaoException {

        return contractService.update(contract);


    }


    @Override
    public boolean updateList(List<Contract> contractList) throws ServiceException, ServiceDaoException {

        return contractService.updateList(contractList);


    }


    @Override
    public Contract getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return contractService.getObjectById(id);


    }


    @Override
    public List<Contract> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return contractService.getObjectsByIds(ids);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getContractIdsByUserId(Long userId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return contractService.getContractIdsByUserId(userId, start, limit);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getContractIdsByUserIdAndTypeAndProjectId(Long userId, Integer type, Long projectId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return contractService.getContractIdsByUserIdAndTypeAndProjectId(userId, type, projectId, start, limit);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getContractIdsByCustomerId(Long customerId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return contractService.getContractIdsByCustomerId(customerId, start, limit);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getContractIdsByCustomerIdAndType(Long customerId, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return contractService.getContractIdsByCustomerIdAndType(customerId, type, start, limit);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getContractIdsByUserIdAndType(Long userId, Integer type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return contractService.getContractIdsByUserIdAndType(userId, type, start, limit);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countContractIdsByUserId(Long userId) throws ServiceException, ServiceDaoException {

        return contractService.countContractIdsByUserId(userId);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countContractIdsByUserIdAndTypeAndProjectId(Long userId, Integer type, Long projectId) throws ServiceException, ServiceDaoException {

        return contractService.countContractIdsByUserIdAndTypeAndProjectId(userId, type, projectId);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countContractIdsByCustomerId(Long customerId) throws ServiceException, ServiceDaoException {

        return contractService.countContractIdsByCustomerId(customerId);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countContractIdsByCustomerIdAndType(Long customerId, Integer type) throws ServiceException, ServiceDaoException {

        return contractService.countContractIdsByCustomerIdAndType(customerId, type);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countContractIdsByUserIdAndType(Long userId, Integer type) throws ServiceException, ServiceDaoException {

        return contractService.countContractIdsByUserIdAndType(userId, type);


    }


    @Override
    public List<Long> getContractIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return contractService.getContractIds(start, limit);
    }

    @Override
    public Integer countContractIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return contractService.countContractIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return contractService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return contractService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        contractService.deleteList(clz, ids);

    }

    @Override
    public Object getObjectByDynamicCondition(Class clz,
                                              Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.contractService.getObjectByDynamicCondition(clz, conditions, start, limit);
    }

    @Override
    public Object getMapListByDynamicCondition(Class clz,
                                               Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.contractService.getMapListByDynamicCondition(clz, conditions, start, limit);
    }


}

