/**
 * 
 */
package com.ptteng.sca.employment.common.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.employment.common.model.Account;
import com.ptteng.employment.common.service.AccountService;

import java.util.List;
import java.util.Map;

public class AccountSCAClient implements AccountService {

    private AccountService accountService;

	public AccountService getAccountService() {
		return accountService;
	}
	
	
	public void setAccountService(AccountService accountService) {
		this.accountService =accountService;
	}
	
	
			   
		@Override
		public Long insert(Account account)throws ServiceException, ServiceDaoException{
		
		return accountService.insert(account);
		          
		
		}	
		  
    	   
		@Override
		public List<Account> insertList(List<Account> accountList)throws ServiceException, ServiceDaoException{
		
		return accountService.insertList(accountList);
		          
		
		}	
		  
    	   
		@Override
		public boolean delete(Long id)throws ServiceException, ServiceDaoException{
		
		return accountService.delete(id);
		          
		
		}	
		  
    	   
		@Override
		public boolean update(Account account)throws ServiceException, ServiceDaoException{
		
		return accountService.update(account);
		          
		
		}	
		  
    	   
		@Override
		public boolean updateList(List<Account> accountList)throws ServiceException, ServiceDaoException{
		
		return accountService.updateList(accountList);
		          
		
		}	
		  
    	   
		@Override
		public Account getObjectById(Long id)throws ServiceException, ServiceDaoException{
		
		return accountService.getObjectById(id);
		          
		
		}	
		  
    	   
		@Override
		public List<Account> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException{
		
		return accountService.getObjectsByIds(ids);
		          
		
		}	
		  
    	
	
	
	
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getAccountIdsByCustomerIdAndServiceProviderId(Long customerId,Long serviceProviderId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return accountService.getAccountIdsByCustomerIdAndServiceProviderId(customerId,serviceProviderId,start,limit);
	
	
	}

    @Override
    public List<Long> getAccountIdsByCustomerIdAndServiceProviderIdAndAccountType(Long customerId, Long serviceProviderId, String accountType, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return accountService.getAccountIdsByCustomerIdAndServiceProviderIdAndAccountType(customerId,serviceProviderId,accountType,start,limit);
    }


    /**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public List<Long>  getAccountIdsByCustomerId(Long customerId,Integer start,Integer limit)throws ServiceException, ServiceDaoException{
		
		return accountService.getAccountIdsByCustomerId(customerId,start,limit);
	
	
	}

    @Override
    public List<Long> getAccountIdsByCustomerIdAndAccountType(Long customerId, String accountType, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return accountService.getAccountIdsByCustomerIdAndAccountType(customerId,accountType,start,limit);
    }


    /**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countAccountIdsByCustomerIdAndServiceProviderId(Long customerId,Long serviceProviderId)throws ServiceException, ServiceDaoException{
		
		return accountService.countAccountIdsByCustomerIdAndServiceProviderId(customerId,serviceProviderId);
	
	
	}
	
			
			
		/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	 @Override
	public Integer  countAccountIdsByCustomerId(Long customerId)throws ServiceException, ServiceDaoException{
		
		return accountService.countAccountIdsByCustomerId(customerId);
	
	
	}
	
		
	
		@Override
	public List<Long> getAccountIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return accountService.getAccountIds(start, limit);
	}

	@Override
	public Integer countAccountIds() throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return accountService.countAccountIds();
	}
	
	
	@Override
	public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return accountService.getIdsByDynamicCondition(clz, conditions, start, limit);
	}


	@Override
	public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
		// TODO Auto-generated method stub
		return accountService.fakeDelete(clz, id);
	}
	
	
	
	@Override
	public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
		   accountService.deleteList(clz, ids);
		
	}
	
	@Override
	public Object getObjectByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {
	
		return this.accountService.getObjectByDynamicCondition(clz, conditions, start, limit);
	}
	@Override
	public Object getMapListByDynamicCondition(Class clz,
			Map<String, Object> conditions, Integer start, Integer limit)
			throws ServiceException, ServiceDaoException {

		return this.accountService.getMapListByDynamicCondition(clz, conditions, start, limit);
	}


 
}

