package com.ptteng.employment.common.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.employment.common.model.SysLog;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface SysLogService extends BaseDaoService {


    public Long insert(SysLog sysLog) throws ServiceException, ServiceDaoException;


    public List<SysLog> insertList(List<SysLog> sysLogList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(SysLog sysLog) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<SysLog> sysLogList) throws ServiceException, ServiceDaoException;


    public SysLog getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<SysLog> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countSysLogIdsByCreateBy(Long createBy) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getSysLogIdsByCreateBy(Long createBy, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getSysLogIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countSysLogIds() throws ServiceException, ServiceDaoException;


}

