package com.ptteng.employment.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.employment.common.model.ProjectComment;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface ProjectCommentService extends BaseDaoService {

	



   		   
		
		public Long insert(ProjectComment projectComment)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<ProjectComment> insertList(List<ProjectComment> projectCommentList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(ProjectComment projectComment)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<ProjectComment> projectCommentList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public ProjectComment getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<ProjectComment> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countProjectCommentIdsByProjectId(Long projectId)throws ServiceException, ServiceDaoException;
			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countProjectCommentIdsByUserId(Long userId)throws ServiceException, ServiceDaoException;
					
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getProjectCommentIdsByProjectId(Long projectId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Long  getProjectCommentIdsByProjectIdAndUserId(Long projectId,Long userId)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getProjectCommentIdsByUserId(Long userId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
		
	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getProjectCommentIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countProjectCommentIds() throws ServiceException, ServiceDaoException;
	

}

