package com.ptteng.employment.common.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.employment.common.model.InvoiceOrder;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface InvoiceOrderService extends BaseDaoService {


    public Long insert(InvoiceOrder invoiceOrder) throws ServiceException, ServiceDaoException;


    public List<InvoiceOrder> insertList(List<InvoiceOrder> invoiceOrderList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(InvoiceOrder invoiceOrder) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<InvoiceOrder> invoiceOrderList) throws ServiceException, ServiceDaoException;


    public InvoiceOrder getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<InvoiceOrder> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countInvoiceOrderIdsByCustomerId(Long customerId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getInvoiceOrderIdByOrderNumber(String orderNumber) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getInvoiceOrderIdsByCustomerId(Long customerId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getInvoiceOrderIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countInvoiceOrderIds() throws ServiceException, ServiceDaoException;


}

