package com.ptteng.employment.common.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.employment.common.model.InvoiceInfo;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface InvoiceInfoService extends BaseDaoService {


    public Long insert(InvoiceInfo invoiceInfo) throws ServiceException, ServiceDaoException;


    public List<InvoiceInfo> insertList(List<InvoiceInfo> invoiceInfoList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(InvoiceInfo invoiceInfo) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<InvoiceInfo> invoiceInfoList) throws ServiceException, ServiceDaoException;


    public InvoiceInfo getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<InvoiceInfo> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countInvoiceInfoIdsByCustomerId(Long customerId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getInvoiceInfoIdsByCustomerId(Long customerId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getInvoiceInfoIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countInvoiceInfoIds() throws ServiceException, ServiceDaoException;


}

