package com.ptteng.employment.common.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.employment.common.model.InvoiceCategory;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface InvoiceCategoryService extends BaseDaoService {


    public Long insert(InvoiceCategory invoiceCategory) throws ServiceException, ServiceDaoException;


    public List<InvoiceCategory> insertList(List<InvoiceCategory> invoiceCategoryList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(InvoiceCategory invoiceCategory) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<InvoiceCategory> invoiceCategoryList) throws ServiceException, ServiceDaoException;


    public InvoiceCategory getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<InvoiceCategory> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countInvoiceCategoryIdsByServiceProviderId(Long serviceProviderId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getInvoiceCategoryIdsByServiceProviderId(Long serviceProviderId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getInvoiceCategoryIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countInvoiceCategoryIds() throws ServiceException, ServiceDaoException;


}

