package com.ptteng.employment.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.employment.common.model.CustomerRole;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface CustomerRoleService extends BaseDaoService {


    public Long insert(CustomerRole role) throws ServiceException, ServiceDaoException;


    public List<CustomerRole> insertList(List<CustomerRole> roleList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(CustomerRole role) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<CustomerRole> roleList) throws ServiceException, ServiceDaoException;


    public CustomerRole getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<CustomerRole> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getCustomerRoleIdsByName(String name, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getCustomerRoleIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countCustomerRoleIds() throws ServiceException, ServiceDaoException;


}

