package com.ptteng.employment.common.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.employment.common.model.CustomerRateItem;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface CustomerRateItemService extends BaseDaoService {


    public Long insert(CustomerRateItem customerRateItem) throws ServiceException, ServiceDaoException;


    public List<CustomerRateItem> insertList(List<CustomerRateItem> customerRateItemList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(CustomerRateItem customerRateItem) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<CustomerRateItem> customerRateItemList) throws ServiceException, ServiceDaoException;


    public CustomerRateItem getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<CustomerRateItem> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countCustomerRateItemIdsByCustomerRateId(Long customerRateId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getCustomerRateItemIdsByCustomerRateId(Long customerRateId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getCustomerRateItemIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countCustomerRateItemIds() throws ServiceException, ServiceDaoException;


}

