package com.ptteng.employment.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.employment.common.model.CustomerModule;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface CustomerModuleService extends BaseDaoService {


    public Long insert(CustomerModule module) throws ServiceException, ServiceDaoException;


    public List<CustomerModule> insertList(List<CustomerModule> moduleList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(CustomerModule module) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<CustomerModule> moduleList) throws ServiceException, ServiceDaoException;


    public CustomerModule getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<CustomerModule> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countCustomerModuleIdsByType(String type) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getCustomerModuleIdsByType(String type, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getCustomerModuleIdByUrlAndType(String url, String type) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getCustomerModuleIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countCustomerModuleIds() throws ServiceException, ServiceDaoException;


}

