package com.ptteng.employment.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.employment.common.model.Account;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface AccountService extends BaseDaoService {

	



   		   
		
		public Long insert(Account account)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Account> insertList(List<Account> accountList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean delete(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean update(Account account)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public boolean updateList(List<Account> accountList)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public Account getObjectById(Long id)throws ServiceException, ServiceDaoException;
		  
    	   
		
		public List<Account> getObjectsByIds(List<Long> ids)throws ServiceException, ServiceDaoException;
		  
    	
	


			
			
	/**
	 * 
	 * @param 
	 * @return 
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countAccountIdsByCustomerIdAndServiceProviderId(Long customerId, Long serviceProviderId)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer  countAccountIdsByCustomerId(Long customerId)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getAccountIdsByCustomerIdAndServiceProviderId(Long customerId, Long serviceProviderId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getAccountIdsByCustomerIdAndServiceProviderIdAndAccountType(Long customerId, Long serviceProviderId,String accountType, Integer start, Integer limit)throws ServiceException, ServiceDaoException;


	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getAccountIdsByCustomerId(Long customerId, Integer start, Integer limit)throws ServiceException, ServiceDaoException;
	/**
	 *
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long>  getAccountIdsByCustomerIdAndAccountType(Long customerId,String accountType, Integer start, Integer limit)throws ServiceException, ServiceDaoException;

	
	
	
	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public List<Long> getAccountIds(Integer start, Integer limit)
			throws ServiceException, ServiceDaoException;

	/**
	 * 
	 * @param
	 * @return
	 * @throws ServiceException
	 * @throws ServiceDaoException
	 */
	public Integer countAccountIds() throws ServiceException, ServiceDaoException;
	

}

