package com.ptteng.employment.common.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;


@Entity
@Table(name = "project_comment")
public class ProjectComment implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 8681673141983766528L;	
	
		
	/**
	 *  未回复
	 * 
	 */
	public static final Integer STATUS_NO_REPLY = 0;
    	
	/**
	 *  已屏蔽
	 * 
	 */
	public static final Integer STATUS_DISABLE = -1;
    	
	/**
	 *  已回复
	 * 
	 */
	public static final Integer STATUS_REPLY = 1;
    	
   
   /**
   *  自增长ID
   *
   */
    private  Long id;
	
  
   /**
   *  项目id
   *
   */
    private  Long projectId;
	
  
   /**
   *  评价内容
   *
   */
    private  String content;
	
  
   /**
   *  回复人
   *
   */
    private  Long replyBy;
   /**
   *  回复人
   *
   */
    private  String replier;

  
   /**
   *  评价时间
   *
   */
    private  Long replyAt;
	
  
   /**
   *  回复
   *
   */
    private  String reply;
	
  
   /**
   *  状态
   *
   */
    private  Integer status;
   /**
   *  经济分
   *
   */
    private  Integer economyScore;
   /**
   *  难度分
   *
   */
    private  Integer difficultyScore;
   /**
   *  推荐分
   *
   */
    private  Integer recommendScore;
   /**
   *  推荐分
   *
   */
    private BigDecimal avgScore;

  
   /**
   *  零客id
   *
   */
    private  Long userId;
	
  
   /**
   *  创建时间
   *
   */
    private  Long createAt;
	
  
   /**
   *  更新时间
   *
   */
    private  Long updateAt;
	
  
   /**
   *  创建人
   *
   */
    private  Long createBy;
	
  
   /**
   *  更新人
   *
   */
    private  Long updateBy;
	
  
	
		 	
         	 	   @Id
     	   @GeneratedValue(strategy = GenerationType.AUTO)
              	@Column(name = "id")
	public Long getId() {
		return id;
	}
	
	
	public void setId(Long id) {
		this.id = id;
	}
		 	@Column(name = "project_id")
	public Long getProjectId() {
		return projectId;
	}
	
	
	public void setProjectId(Long projectId) {
		this.projectId = projectId;
	}
		 	@Column(name = "content")
	public String getContent() {
		return content;
	}
	
	
	public void setContent(String content) {
		this.content = content;
	}
		 	@Column(name = "reply_by")
	public Long getReplyBy() {
		return replyBy;
	}
	
	
	public void setReplyBy(Long replyBy) {
		this.replyBy = replyBy;
	}
		 	@Column(name = "reply_at")
	public Long getReplyAt() {
		return replyAt;
	}
	
	
	public void setReplyAt(Long replyAt) {
		this.replyAt = replyAt;
	}
		 	@Column(name = "reply")
	public String getReply() {
		return reply;
	}
	
	
	public void setReply(String reply) {
		this.reply = reply;
	}
		 	@Column(name = "status")
	public Integer getStatus() {
		return status;
	}
	
	
	public void setStatus(Integer status) {
		this.status = status;
	}
		 	@Column(name = "user_id")
	public Long getUserId() {
		return userId;
	}
	
	
	public void setUserId(Long userId) {
		this.userId = userId;
	}
		 	@Column(name = "create_at")
	public Long getCreateAt() {
		return createAt;
	}
	
	
	public void setCreateAt(Long createAt) {
		this.createAt = createAt;
	}
		 	@Column(name = "update_at")
	public Long getUpdateAt() {
		return updateAt;
	}
	
	
	public void setUpdateAt(Long updateAt) {
		this.updateAt = updateAt;
	}
		 	@Column(name = "create_by")
	public Long getCreateBy() {
		return createBy;
	}
	
	
	public void setCreateBy(Long createBy) {
		this.createBy = createBy;
	}
		 	@Column(name = "update_by")
	public Long getUpdateBy() {
		return updateBy;
	}
	
	
	public void setUpdateBy(Long updateBy) {
		this.updateBy = updateBy;
	}
    @Column(name = "replier")
    public String getReplier() {
        return replier;
    }

    public void setReplier(String replier) {
        this.replier = replier;
    }
    @Column(name = "economy_score")
    public Integer getEconomyScore() {
        return economyScore;
    }

    public void setEconomyScore(Integer economyScore) {
        this.economyScore = economyScore;
    }
    @Column(name = "difficulty_score")
    public Integer getDifficultyScore() {
        return difficultyScore;
    }

    public void setDifficultyScore(Integer difficultyScore) {
        this.difficultyScore = difficultyScore;
    }
    @Column(name = "recommend_score")
    public Integer getRecommendScore() {
        return recommendScore;
    }

    public void setRecommendScore(Integer recommendScore) {
        this.recommendScore = recommendScore;
    }
	@Column(name = "avg_score")
	public BigDecimal getAvgScore() {
		return avgScore;
	}

	public void setAvgScore(BigDecimal avgScore) {
		this.avgScore = avgScore;
	}

	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}

}

