package com.ptteng.employment.common.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.util.List;


@Entity
@Table(name = "notice")
public class Notice implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 3153017693230220288L;	
	
		
	/**
	 *  公告
	 * 
	 */
	public static final Integer TYPE_NOTICE = 1;
    	
	/**
	 *  banner
	 * 
	 */
	public static final Integer TYPE_BANNER = 2;
    	
	/**
	 *  图片
	 * 
	 */
	public static final Integer CONTENT_TYPE_PIC = 1;
    	
	/**
	 *  视频
	 * 
	 */
	public static final Integer CONTENT_TYPE_VIDEO = 2;
    	
	/**
	 *  pdf
	 * 
	 */
	public static final Integer CONTENT_TYPE_PDF = 3;
    	
	/**
	 *  URL
	 * 
	 */
	public static final Integer CONTENT_TYPE_URL = 4;
    	
	/**
	 *  TEXT
	 * 
	 */
	public static final Integer CONTENT_TYPE_TEXT = 5;
    	
	/**
	 *  未发送
	 * 
	 */
	public static final Integer STATUS_UNSENT = 0;
    	
	/**
	 *  已发送
	 * 
	 */
	public static final Integer STATUS_SENT_SUCCESS = 1;
    	
	/**
	 *  禁用
	 * 
	 */
	public static final Integer STATUS_SENT_DISABLE = -1;
    	
	/**
	 *  发送失败
	 * 
	 */
	public static final Integer STATUS_SENT_FAIL = 2;
    	
	/**
	 *  零客
	 * 
	 */
	public static final String USER_TYPE_USER = "USER";
    	
	/**
	 *  客户
	 * 
	 */
	public static final String USER_TYPE_CUSTOMER = "CUSTOMER";
    	
	/**
	 *  组群
	 * 
	 */
	public static final String USER_TYPE_GROUP = "GROUP";
    	
	/**
	 *  服务商
	 * 
	 */
	public static final String USER_TYPE_SERVICE = "SERVICE";
    	
	/**
	 *  代理商
	 * 
	 */
	public static final String USER_TYPE_AGENT = "AGENT";
    	
	/**
	 *  全部
	 * 
	 */
	public static final String USER_TYPE_ALL = "ALL";
    	
   
   /**
   *  自增长ID
   *
   */
    private  Long id;
	
  
   /**
   *  发送时间
   *
   */
    private  Long sendTime;
	
  
   /**
   *  公告标题
   *
   */
    private  String title;
	
  
   /**
   *  公告内容
   *
   */
    private  String content;

    /**
     *  url
     *
     */
    private  String url;


    /**
   *  组群id
   *
   */
    private  Long groupId;
	
  
   /**
   *  通知用户类型
   *
   */
    private  String userType;
	
  
   /**
   *  消息类型
   *
   */
    private  Integer type;
	
  
   /**
   *  内容类型
   *
   */
    private  Integer contentType;
	
  
   /**
   *  附件
   *
   */
    private  String attachment;
	
  
   /**
   *  状态
   *
   */
    private  Integer status;
	
  
   /**
   *  创建时间
   *
   */
    private  Long createAt;
	
  
   /**
   *  更新时间
   *
   */
    private  Long updateAt;
	
  
   /**
   *  创建人
   *
   */
    private  Long createBy;
	
  
   /**
   *  更新人
   *
   */
    private  Long updateBy;

    //发送对象ids，服务商id，客户id等
    List<Long> userIds;
	
		 	
         	 	   @Id
     	   @GeneratedValue(strategy = GenerationType.AUTO)
              	@Column(name = "id")
	public Long getId() {
		return id;
	}
	
	
	public void setId(Long id) {
		this.id = id;
	}
		 	@Column(name = "send_time")
	public Long getSendTime() {
		return sendTime;
	}
	
	
	public void setSendTime(Long sendTime) {
		this.sendTime = sendTime;
	}
		 	@Column(name = "title")
	public String getTitle() {
		return title;
	}
	
	
	public void setTitle(String title) {
		this.title = title;
	}
		 	@Column(name = "content")
	public String getContent() {
		return content;
	}
	
	
	public void setContent(String content) {
		this.content = content;
	}
		 	@Column(name = "group_id")
	public Long getGroupId() {
		return groupId;
	}
	
	
	public void setGroupId(Long groupId) {
		this.groupId = groupId;
	}
		 	@Column(name = "user_type")
	public String getUserType() {
		return userType;
	}
	
	
	public void setUserType(String userType) {
		this.userType = userType;
	}
		 	@Column(name = "type")
	public Integer getType() {
		return type;
	}
	
	
	public void setType(Integer type) {
		this.type = type;
	}
		 	@Column(name = "content_type")
	public Integer getContentType() {
		return contentType;
	}
	
	
	public void setContentType(Integer contentType) {
		this.contentType = contentType;
	}
		 	@Column(name = "attachment")
	public String getAttachment() {
		return attachment;
	}
	
	
	public void setAttachment(String attachment) {
		this.attachment = attachment;
	}
		 	@Column(name = "status")
	public Integer getStatus() {
		return status;
	}
	
	
	public void setStatus(Integer status) {
		this.status = status;
	}
		 	@Column(name = "create_at")
	public Long getCreateAt() {
		return createAt;
	}
	
	
	public void setCreateAt(Long createAt) {
		this.createAt = createAt;
	}
		 	@Column(name = "update_at")
	public Long getUpdateAt() {
		return updateAt;
	}
	
	
	public void setUpdateAt(Long updateAt) {
		this.updateAt = updateAt;
	}
		 	@Column(name = "create_by")
	public Long getCreateBy() {
		return createBy;
	}
	
	
	public void setCreateBy(Long createBy) {
		this.createBy = createBy;
	}
		 	@Column(name = "update_by")
	public Long getUpdateBy() {
		return updateBy;
	}
	
	
	public void setUpdateBy(Long updateBy) {
		this.updateBy = updateBy;
	}
    @Transient
    public List<Long> getUserIds() {
        return userIds;
    }

    public void setUserIds(List<Long> userIds) {
        this.userIds = userIds;
    }
    @Column(name = "url")
    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}

}

