package com.ptteng.employment.common.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;


@Entity
@Table(name = "invoice_order")
public class InvoiceOrder implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 5788329699559687168L;


    /**
     * 普票
     */
    public static final Integer TYPE_COMMON = 1;

    /**
     * 专票
     */
    public static final Integer TYPE_SPECIAL = 2;

    /**
     * 差额票
     */
    public static final Integer TYPE_BALANCE = 3;

    /**
     * 待审核
     */
    public static final Integer STATUS_CHECK_PENDING = 1;

    /**
     * 开具中
     */
    public static final Integer STATUS_IN_PROCESS = 2;

    /**
     * 已开具
     */
    public static final Integer STATUS_COMPLETE = 3;
    /**
     * 代申请
     */
    public static final Integer IS_AGENCY_TRUE = 1;
    public static final Integer IS_AGENCY_FALSE = 0;
    public static final Integer EXPRESS_FALSE = 0;
    public static final Integer EXPRESS_TURE = 1;


    /**
     * 自增长ID
     */
    private Long id;


    /**
     * 订单编号
     */
    private String orderNumber;


    /**
     * 客户id
     */
    private Long customerId;


    /**
     * 发票抬头
     */
    private String invoiceTitle;


    /**
     * 项目id
     */
    private Long projectId;


    /**
     * 服务商id
     */
    private Long serviceProviderId;


    /**
     * 服务商名
     */
    private String serviceProviderName;
    /**
     * 服务商纳税人识别号
     */
    private String serviceProviderTaxpayerNumber;
    /**
     * 客户纳税人识别号
     */
    private String customerTaxpayerNumber;


    /**
     * 申请开票金额
     */
    private BigDecimal expectedAmount;


    /**
     * 实际开票金额
     */
    private BigDecimal actualAmount;


    /**
     * 开票类目
     */
    private String invoiceCategory;


    /**
     * 发票类型
     */
    private Integer type;


    /**
     * 发票备注
     */
    private String invoiceDesc;


    /**
     * 申请要求
     */
    private String invoiceCondition;


    /**
     * 发票信息
     */
    private String invoiceInfo;


    /**
     * 收货地址
     */
    private String address;
    /**
     * 收货地址
     */
    private Long addressId;


    /**
     * 状态
     */
    private Integer status;


    /**
     * 申请时间
     */
    private Long applyTime;


    /**
     * 审核时间
     */
    private Long checkTime;


    /**
     * 驳回说明
     */
    private String rejectDesc;


    /**
     * 快递名
     */
    private String expressName;


    /**
     * 邮寄状态
     */
    private Integer expressStatus;


    /**
     * 快递单号
     */
    private String expressNumber;


    /**
     * 创建时间
     */
    private Long createAt;


    /**
     * 更新时间
     */
    private Long updateAt;


    /**
     * 创建人
     */
    private Long createBy;


    /**
     * 更新人
     */
    private Long updateBy;


    /**
     * 代申请
     */
    private Integer isAgency;

    List<Long> projectIdList;

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "order_number")
    public String getOrderNumber() {
        return orderNumber;
    }


    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    @Column(name = "customer_id")
    public Long getCustomerId() {
        return customerId;
    }


    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    @Column(name = "invoice_title")
    public String getInvoiceTitle() {
        return invoiceTitle;
    }


    public void setInvoiceTitle(String invoiceTitle) {
        this.invoiceTitle = invoiceTitle;
    }

    @Column(name = "project_id")
    public Long getProjectId() {
        return projectId;
    }


    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    @Column(name = "service_provider_id")
    public Long getServiceProviderId() {
        return serviceProviderId;
    }


    public void setServiceProviderId(Long serviceProviderId) {
        this.serviceProviderId = serviceProviderId;
    }

    @Column(name = "service_provider_name")
    public String getServiceProviderName() {
        return serviceProviderName;
    }


    public void setServiceProviderName(String serviceProviderName) {
        this.serviceProviderName = serviceProviderName;
    }

    @Column(name = "expected_amount")
    public BigDecimal getExpectedAmount() {
        return expectedAmount;
    }


    public void setExpectedAmount(BigDecimal expectedAmount) {
        this.expectedAmount = expectedAmount;
    }

    @Column(name = "actual_amount")
    public BigDecimal getActualAmount() {
        return actualAmount;
    }


    public void setActualAmount(BigDecimal actualAmount) {
        this.actualAmount = actualAmount;
    }

    @Column(name = "invoice_category")
    public String getInvoiceCategory() {
        return invoiceCategory;
    }


    public void setInvoiceCategory(String invoiceCategory) {
        this.invoiceCategory = invoiceCategory;
    }

    @Column(name = "type")
    public Integer getType() {
        return type;
    }


    public void setType(Integer type) {
        this.type = type;
    }

    @Column(name = "invoice_desc")
    public String getInvoiceDesc() {
        return invoiceDesc;
    }


    public void setInvoiceDesc(String invoiceDesc) {
        this.invoiceDesc = invoiceDesc;
    }

    @Column(name = "invoice_condition")
    public String getInvoiceCondition() {
        return invoiceCondition;
    }


    public void setInvoiceCondition(String condition) {
        this.invoiceCondition = condition;
    }

    @Column(name = "invoice_info")
    public String getInvoiceInfo() {
        return invoiceInfo;
    }


    public void setInvoiceInfo(String invoiceInfo) {
        this.invoiceInfo = invoiceInfo;
    }

    @Column(name = "address")
    public String getAddress() {
        return address;
    }


    public void setAddress(String address) {
        this.address = address;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "apply_time")
    public Long getApplyTime() {
        return applyTime;
    }


    public void setApplyTime(Long applyTime) {
        this.applyTime = applyTime;
    }

    @Column(name = "check_time")
    public Long getCheckTime() {
        return checkTime;
    }


    public void setCheckTime(Long checkTime) {
        this.checkTime = checkTime;
    }

    @Column(name = "reject_desc")
    public String getRejectDesc() {
        return rejectDesc;
    }


    public void setRejectDesc(String rejectDesc) {
        this.rejectDesc = rejectDesc;
    }

    @Column(name = "express_name")
    public String getExpressName() {
        return expressName;
    }


    public void setExpressName(String expressName) {
        this.expressName = expressName;
    }

    @Column(name = "express_status")
    public Integer getExpressStatus() {
        return expressStatus;
    }


    public void setExpressStatus(Integer expressStatus) {
        this.expressStatus = expressStatus;
    }

    @Column(name = "express_number")
    public String getExpressNumber() {
        return expressNumber;
    }


    public void setExpressNumber(String expressNumber) {
        this.expressNumber = expressNumber;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "is_agency")
    public Integer getIsAgency() {
        return isAgency;
    }


    public void setIsAgency(Integer isAgency) {
        this.isAgency = isAgency;
    }
    @Column(name = "address_id")
    public Long getAddressId() {
        return addressId;
    }

    public void setAddressId(Long addressId) {
        this.addressId = addressId;
    }
    @Transient
    public List<Long> getProjectIdList() {
        return projectIdList;
    }

    public void setProjectIdList(List<Long> projectIdList) {
        this.projectIdList = projectIdList;
    }
    @Column(name = "service_provider_taxpayer_number")
    public String getServiceProviderTaxpayerNumber() {
        return serviceProviderTaxpayerNumber;
    }

    public void setServiceProviderTaxpayerNumber(String serviceProviderTaxpayerNumber) {
        this.serviceProviderTaxpayerNumber = serviceProviderTaxpayerNumber;
    }
    @Column(name = "customer_taxpayer_number")
    public String getCustomerTaxpayerNumber() {
        return customerTaxpayerNumber;
    }

    public void setCustomerTaxpayerNumber(String customerTaxpayerNumber) {
        this.customerTaxpayerNumber = customerTaxpayerNumber;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

