package com.ptteng.employment.common.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "group_user")
public class GroupUser implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 967830642678148096L;

    /**
     *  零客
     *
     */
    public static final String USER_TYPE_USER = "USER";

    /**
     *  客户
     *
     */
    public static final String USER_TYPE_CUSTOMER = "CUSTOMER";

    /**
     *  组群
     *
     */
    public static final String USER_TYPE_GROUP = "GROUP";

    /**
     *  服务商
     *
     */
    public static final String USER_TYPE_SERVICE = "SERVICE";

    /**
     *  代理商
     *
     */
    public static final String USER_TYPE_AGENT = "AGENT";

    /**
     *  全部
     *
     */
    public static final String USER_TYPE_ALL = "ALL";
   
   /**
   *  自增长ID
   *
   */
    private  Long id;
	
  
   /**
   *  组群id
   *
   */
    private  Long groupId;
	
  
   /**
   *  组群类别
   *
   */
    private  String userType;
	
  
   /**
   *  人员id
   *
   */
    private  Long userId;
	
  
   /**
   *  创建时间
   *
   */
    private  Long createAt;
	
  
   /**
   *  更新时间
   *
   */
    private  Long updateAt;
	
  
   /**
   *  创建人
   *
   */
    private  Long createBy;
	
  
   /**
   *  更新人
   *
   */
    private  Long updateBy;
	
  
	
		 	
         	 	   @Id
     	   @GeneratedValue(strategy = GenerationType.AUTO)
              	@Column(name = "id")
	public Long getId() {
		return id;
	}
	
	
	public void setId(Long id) {
		this.id = id;
	}
		 	@Column(name = "group_id")
	public Long getGroupId() {
		return groupId;
	}
	
	
	public void setGroupId(Long groupId) {
		this.groupId = groupId;
	}
		 	@Column(name = "user_type")
	public String getUserType() {
		return userType;
	}
	
	
	public void setUserType(String userType) {
		this.userType = userType;
	}
		 	@Column(name = "user_id")
	public Long getUserId() {
		return userId;
	}
	
	
	public void setUserId(Long userId) {
		this.userId = userId;
	}
		 	@Column(name = "create_at")
	public Long getCreateAt() {
		return createAt;
	}
	
	
	public void setCreateAt(Long createAt) {
		this.createAt = createAt;
	}
		 	@Column(name = "update_at")
	public Long getUpdateAt() {
		return updateAt;
	}
	
	
	public void setUpdateAt(Long updateAt) {
		this.updateAt = updateAt;
	}
		 	@Column(name = "create_by")
	public Long getCreateBy() {
		return createBy;
	}
	
	
	public void setCreateBy(Long createBy) {
		this.createBy = createBy;
	}
		 	@Column(name = "update_by")
	public Long getUpdateBy() {
		return updateBy;
	}
	
	
	public void setUpdateBy(Long updateBy) {
		this.updateBy = updateBy;
	}
		
	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}

}

