package com.ptteng.employment.common.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;


@Entity
@Table(name = "customer_role")
public class CustomerRole implements Serializable {


    /**
     * 启用
     */
    public static final String STATUS_USING = "using";
    public static final Integer PERMISSION_TYPE_ALL = 1;
    public static final Integer PERMISSION_TYPE_SELF = 2;
    /**
     * 停用
     */
    public static final String STATUS_STOPPED = "stopped";
    private static final long serialVersionUID = 8483443024528168433L;

    private Long id;
    private Long customerId;

    private String name;

    private Set<Long> permissionsSet;

    private String permissions;

    private String status;
    private Integer level;

    private Long updateAt;

    private Long updateBy;

    private Long createAt;

    private Long createBy;
    private Integer permissionType;
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "permissions")
    public String getPermissions() {
        return permissions;
    }

    public void setPermissions(String permissions) {

        this.permissions = permissions;

        Gson gson = new GsonBuilder().create();
        Map<Long, Object> map = gson.fromJson(this.permissions, new TypeToken<Map<Long, Object>>() {
        }.getType());
        permissionsSet =new HashSet<Long>(map.keySet()) ;
    }

    @Column(name = "status")
    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }

    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }

    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }

    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }

    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }
    @Column(name = "customer_id")
    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    @Column(name = "level")
    public Integer getLevel() {
        return level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }
    @Column(name = "permission_type")
    public Integer getPermissionType() {
        return permissionType;
    }

    public void setPermissionType(Integer permissionType) {
        this.permissionType = permissionType;
    }

    @Transient
    public Set<Long> getPermissionsSet() {
        if (StringUtils.isBlank(this.permissions)) {
            return new HashSet();
        } else {
            if (this.permissionsSet == null) {
                Gson gson = new GsonBuilder().create();
                Map<Long, Object> map = gson.fromJson(this.permissions, new TypeToken<Map<Long, Object>>() {
                }.getType());
                permissionsSet =new HashSet<Long>(map.keySet()) ;

            }
        }
        return permissionsSet;
    }

    public void setPermissionsSet(Set<Long> permissionsSet) {

        this.permissionsSet = permissionsSet;
//        Gson gson = new GsonBuilder().create();
//        this.permissions = gson.toJson(permissionsSet);
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.MULTI_LINE_STYLE);
    }

//    public static void main(String[] args) {
//
//        CustomerRole r = new CustomerRole();
//        r.setPermissionsSet(new HashSet(Arrays.asList(new Long[]{3L, 4L, 5L})));
//        System.out.println(r);
//        r.setPermissions("[5,6]");
//        System.out.println(r);
//
//    }

}

