package com.ptteng.employment.common.model;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "customer_rate")
public class CustomerRate implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 8729832818893761536L;


    /**
     * 内扣
     */
    public static final Integer BILLING_MODEL_IN = 1;

    /**
     * 外扣
     */
    public static final Integer BILLING_MODEL_OUT = 2;


    /**
     * 自增长ID
     */
    private Long id;


    /**
     * 客户id
     */
    private Long customerId;


    /**
     * 合作服务商
     */
    private Long serviceProviderId;


    /**
     * 计费方式
     */
    private Integer billingMode;


    /**
     * 主要开票类目
     */
    private String invoiceCategory;
    /**
     * 主要开票类目JSON
     */
    private String invoiceCategoryJson;


    /**
     * 创建时间
     */
    private Long createAt;


    /**
     * 更新时间
     */
    private Long updateAt;


    /**
     * 创建人
     */
    private Long createBy;


    /**
     * 更新人
     */
    private Long updateBy;


    private List<CustomerRateItem> customerRateItemList;
    private List<Long> categoryIdList;

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "customer_id")
    public Long getCustomerId() {
        return customerId;
    }


    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    @Column(name = "service_provider_id")
    public Long getServiceProviderId() {
        return serviceProviderId;
    }


    public void setServiceProviderId(Long serviceProviderId) {
        this.serviceProviderId = serviceProviderId;
    }

    @Column(name = "billing_mode")
    public Integer getBillingMode() {
        return billingMode;
    }


    public void setBillingMode(Integer billingMode) {
        this.billingMode = billingMode;
    }

    @Column(name = "invoice_category")
    public String getInvoiceCategory() {
        return invoiceCategory;
    }


    public void setInvoiceCategory(String invoiceCategory) {
        this.invoiceCategory = invoiceCategory;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }
    @Transient
    public List<CustomerRateItem> getCustomerRateItemList() {
        return customerRateItemList;
    }

    public void setCustomerRateItemList(List<CustomerRateItem> customerRateItemList) {
        this.customerRateItemList = customerRateItemList;
    }
    @Column(name = "invoice_category_json")
    public String getInvoiceCategoryJson() {
        return invoiceCategoryJson;
    }

    public void setInvoiceCategoryJson(String invoiceCategoryJson) {
        this.invoiceCategoryJson = invoiceCategoryJson;
    }
    @Transient
    public List<Long> getCategoryIdList() {
        return categoryIdList;
    }

    public void setCategoryIdList(List<Long> categoryIdList) {
        this.categoryIdList = categoryIdList;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

