/**
 *
 */
package com.ptteng.sca.employment.common.client;

import java.util.List;
import java.util.Map;

import com.ptteng.employment.common.model.InvoiceOrder;
import com.ptteng.employment.common.service.InvoiceOrderService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class InvoiceOrderSCAClient implements InvoiceOrderService {

    private InvoiceOrderService invoiceOrderService;

    public InvoiceOrderService getInvoiceOrderService() {
        return invoiceOrderService;
    }


    public void setInvoiceOrderService(InvoiceOrderService invoiceOrderService) {
        this.invoiceOrderService = invoiceOrderService;
    }


    @Override
    public Long insert(InvoiceOrder invoiceOrder) throws ServiceException, ServiceDaoException {

        return invoiceOrderService.insert(invoiceOrder);


    }


    @Override
    public List<InvoiceOrder> insertList(List<InvoiceOrder> invoiceOrderList) throws ServiceException, ServiceDaoException {

        return invoiceOrderService.insertList(invoiceOrderList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return invoiceOrderService.delete(id);


    }


    @Override
    public boolean update(InvoiceOrder invoiceOrder) throws ServiceException, ServiceDaoException {

        return invoiceOrderService.update(invoiceOrder);


    }


    @Override
    public boolean updateList(List<InvoiceOrder> invoiceOrderList) throws ServiceException, ServiceDaoException {

        return invoiceOrderService.updateList(invoiceOrderList);


    }


    @Override
    public InvoiceOrder getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return invoiceOrderService.getObjectById(id);


    }


    @Override
    public List<InvoiceOrder> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return invoiceOrderService.getObjectsByIds(ids);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getInvoiceOrderIdByOrderNumber(String orderNumber) throws ServiceException, ServiceDaoException {

        return invoiceOrderService.getInvoiceOrderIdByOrderNumber(orderNumber);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getInvoiceOrderIdsByCustomerId(Long customerId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return invoiceOrderService.getInvoiceOrderIdsByCustomerId(customerId, start, limit);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countInvoiceOrderIdsByCustomerId(Long customerId) throws ServiceException, ServiceDaoException {

        return invoiceOrderService.countInvoiceOrderIdsByCustomerId(customerId);


    }


    @Override
    public List<Long> getInvoiceOrderIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return invoiceOrderService.getInvoiceOrderIds(start, limit);
    }

    @Override
    public Integer countInvoiceOrderIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return invoiceOrderService.countInvoiceOrderIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return invoiceOrderService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return invoiceOrderService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        invoiceOrderService.deleteList(clz, ids);

    }

    @Override
    public Object getObjectByDynamicCondition(Class clz,
                                              Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.invoiceOrderService.getObjectByDynamicCondition(clz, conditions, start, limit);
    }

    @Override
    public Object getMapListByDynamicCondition(Class clz,
                                               Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.invoiceOrderService.getMapListByDynamicCondition(clz, conditions, start, limit);
    }


}

