/**
 *
 */
package com.ptteng.sca.employment.common.client;

import java.util.List;
import java.util.Map;

import com.ptteng.employment.common.model.InvoiceInfo;
import com.ptteng.employment.common.service.InvoiceInfoService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class InvoiceInfoSCAClient implements InvoiceInfoService {

    private InvoiceInfoService invoiceInfoService;

    public InvoiceInfoService getInvoiceInfoService() {
        return invoiceInfoService;
    }


    public void setInvoiceInfoService(InvoiceInfoService invoiceInfoService) {
        this.invoiceInfoService = invoiceInfoService;
    }


    @Override
    public Long insert(InvoiceInfo invoiceInfo) throws ServiceException, ServiceDaoException {

        return invoiceInfoService.insert(invoiceInfo);


    }


    @Override
    public List<InvoiceInfo> insertList(List<InvoiceInfo> invoiceInfoList) throws ServiceException, ServiceDaoException {

        return invoiceInfoService.insertList(invoiceInfoList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return invoiceInfoService.delete(id);


    }


    @Override
    public boolean update(InvoiceInfo invoiceInfo) throws ServiceException, ServiceDaoException {

        return invoiceInfoService.update(invoiceInfo);


    }


    @Override
    public boolean updateList(List<InvoiceInfo> invoiceInfoList) throws ServiceException, ServiceDaoException {

        return invoiceInfoService.updateList(invoiceInfoList);


    }


    @Override
    public InvoiceInfo getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return invoiceInfoService.getObjectById(id);


    }


    @Override
    public List<InvoiceInfo> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return invoiceInfoService.getObjectsByIds(ids);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getInvoiceInfoIdsByCustomerId(Long customerId) throws ServiceException, ServiceDaoException {

        return invoiceInfoService.getInvoiceInfoIdsByCustomerId(customerId);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countInvoiceInfoIdsByCustomerId(Long customerId) throws ServiceException, ServiceDaoException {

        return invoiceInfoService.countInvoiceInfoIdsByCustomerId(customerId);


    }


    @Override
    public List<Long> getInvoiceInfoIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return invoiceInfoService.getInvoiceInfoIds(start, limit);
    }

    @Override
    public Integer countInvoiceInfoIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return invoiceInfoService.countInvoiceInfoIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return invoiceInfoService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return invoiceInfoService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        invoiceInfoService.deleteList(clz, ids);

    }

    @Override
    public Object getObjectByDynamicCondition(Class clz,
                                              Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.invoiceInfoService.getObjectByDynamicCondition(clz, conditions, start, limit);
    }

    @Override
    public Object getMapListByDynamicCondition(Class clz,
                                               Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.invoiceInfoService.getMapListByDynamicCondition(clz, conditions, start, limit);
    }


}

