/**
 *
 */
package com.ptteng.sca.employment.common.client;

import java.util.List;
import java.util.Map;

import com.ptteng.employment.common.model.Customer;
import com.ptteng.employment.common.service.CustomerService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class CustomerSCAClient implements CustomerService {

    private CustomerService customerService;

    public CustomerService getCustomerService() {
        return customerService;
    }


    public void setCustomerService(CustomerService customerService) {
        this.customerService = customerService;
    }


    @Override
    public Long insert(Customer customer) throws ServiceException, ServiceDaoException {

        return customerService.insert(customer);


    }


    @Override
    public List<Customer> insertList(List<Customer> customerList) throws ServiceException, ServiceDaoException {

        return customerService.insertList(customerList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return customerService.delete(id);


    }


    @Override
    public boolean update(Customer customer) throws ServiceException, ServiceDaoException {

        return customerService.update(customer);


    }


    @Override
    public boolean updateList(List<Customer> customerList) throws ServiceException, ServiceDaoException {

        return customerService.updateList(customerList);


    }


    @Override
    public Customer getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return customerService.getObjectById(id);


    }


    @Override
    public List<Customer> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return customerService.getObjectsByIds(ids);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getCustomerIdByCustomerNo(String customerNo) throws ServiceException, ServiceDaoException {

        return customerService.getCustomerIdByCustomerNo(customerNo);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getCustomerIdByCreditCode(String creditCode) throws ServiceException, ServiceDaoException {

        return customerService.getCustomerIdByCreditCode(creditCode);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getCustomerIdByCustomerNoAndStatus(String customerNo, Integer status) throws ServiceException, ServiceDaoException {

        return customerService.getCustomerIdByCustomerNoAndStatus(customerNo, status);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getCustomerIdByCreditCodeAndStatus(String creditCode, Integer status) throws ServiceException, ServiceDaoException {

        return customerService.getCustomerIdByCreditCodeAndStatus(creditCode, status);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countCustomerIdsByCreditCode(String creditCode) throws ServiceException, ServiceDaoException {

        return customerService.countCustomerIdsByCreditCode(creditCode);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countCustomerIdsByCreditCodeAndStatus(String creditCode, Integer status) throws ServiceException, ServiceDaoException {

        return customerService.countCustomerIdsByCreditCodeAndStatus(creditCode, status);


    }


    @Override
    public List<Long> getCustomerIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return customerService.getCustomerIds(start, limit);
    }

    @Override
    public Integer countCustomerIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return customerService.countCustomerIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return customerService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return customerService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        customerService.deleteList(clz, ids);

    }

    @Override
    public Object getObjectByDynamicCondition(Class clz,
                                              Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.customerService.getObjectByDynamicCondition(clz, conditions, start, limit);
    }

    @Override
    public Object getMapListByDynamicCondition(Class clz,
                                               Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.customerService.getMapListByDynamicCondition(clz, conditions, start, limit);
    }


}

