/**
 *
 */
package com.ptteng.sca.employment.common.client;

import java.util.List;
import java.util.Map;

import com.ptteng.employment.common.model.CustomerRate;
import com.ptteng.employment.common.service.CustomerRateService;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;

public class CustomerRateSCAClient implements CustomerRateService {

    private CustomerRateService customerRateService;

    public CustomerRateService getCustomerRateService() {
        return customerRateService;
    }


    public void setCustomerRateService(CustomerRateService customerRateService) {
        this.customerRateService = customerRateService;
    }


    @Override
    public Long insert(CustomerRate customerRate) throws ServiceException, ServiceDaoException {

        return customerRateService.insert(customerRate);


    }


    @Override
    public List<CustomerRate> insertList(List<CustomerRate> customerRateList) throws ServiceException, ServiceDaoException {

        return customerRateService.insertList(customerRateList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return customerRateService.delete(id);


    }


    @Override
    public boolean update(CustomerRate customerRate) throws ServiceException, ServiceDaoException {

        return customerRateService.update(customerRate);


    }


    @Override
    public boolean updateList(List<CustomerRate> customerRateList) throws ServiceException, ServiceDaoException {

        return customerRateService.updateList(customerRateList);


    }


    @Override
    public CustomerRate getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return customerRateService.getObjectById(id);


    }


    @Override
    public List<CustomerRate> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return customerRateService.getObjectsByIds(ids);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getCustomerRateIdsByCustomerId(Long customerId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return customerRateService.getCustomerRateIdsByCustomerId(customerId, start, limit);


    }


    /**
     *
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countCustomerRateIdsByCustomerId(Long customerId) throws ServiceException, ServiceDaoException {

        return customerRateService.countCustomerRateIdsByCustomerId(customerId);


    }


    @Override
    public List<Long> getCustomerRateIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return customerRateService.getCustomerRateIds(start, limit);
    }

    @Override
    public Integer countCustomerRateIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return customerRateService.countCustomerRateIds();
    }


    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return customerRateService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return customerRateService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        customerRateService.deleteList(clz, ids);

    }

    @Override
    public Object getObjectByDynamicCondition(Class clz,
                                              Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.customerRateService.getObjectByDynamicCondition(clz, conditions, start, limit);
    }

    @Override
    public Object getMapListByDynamicCondition(Class clz,
                                               Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return this.customerRateService.getMapListByDynamicCondition(clz, conditions, start, limit);
    }


}

