/**
 *
 */
package com.ptteng.sca.employment.common.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.employment.common.model.CustomerModule;
import com.ptteng.employment.common.service.CustomerModuleService;
import org.osoa.sca.annotations.Reference;

import java.util.List;
import java.util.Map;

public class CustomerModuleSCAClient implements CustomerModuleService {

    private CustomerModuleService moduleService;

    public CustomerModuleService getCustomerModuleService() {
        return moduleService;
    }

    @Reference
    public void setCustomerModuleService(CustomerModuleService moduleService) {
        this.moduleService = moduleService;
    }


    @Override
    public Long insert(CustomerModule module) throws ServiceException, ServiceDaoException {

        return moduleService.insert(module);


    }


    @Override
    public List<CustomerModule> insertList(List<CustomerModule> moduleList) throws ServiceException, ServiceDaoException {

        return moduleService.insertList(moduleList);


    }


    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return moduleService.delete(id);


    }


    @Override
    public boolean update(CustomerModule module) throws ServiceException, ServiceDaoException {

        return moduleService.update(module);


    }


    @Override
    public boolean updateList(List<CustomerModule> moduleList) throws ServiceException, ServiceDaoException {

        return moduleService.updateList(moduleList);


    }


    @Override
    public CustomerModule getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return moduleService.getObjectById(id);


    }


    @Override
    public List<CustomerModule> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return moduleService.getObjectsByIds(ids);


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getCustomerModuleIdsByType(String type, Integer start, Integer limit) throws ServiceException, ServiceDaoException {

        return moduleService.getCustomerModuleIdsByType(type, start, limit);


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Long getCustomerModuleIdByUrlAndType(String url, String type) throws ServiceException, ServiceDaoException {

        return moduleService.getCustomerModuleIdByUrlAndType(url, type);


    }


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public Integer countCustomerModuleIdsByType(String type) throws ServiceException, ServiceDaoException {

        return moduleService.countCustomerModuleIdsByType(type);


    }


    @Override
    public List<Long> getCustomerModuleIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return moduleService.getCustomerModuleIds(start, limit);
    }

    @Override
    public Integer countCustomerModuleIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return moduleService.countCustomerModuleIds();
    }

    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return moduleService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }

    @Override
    public Object getObjectByDynamicCondition(Class aClass, Map<String, Object> map, Integer integer, Integer integer1) throws ServiceException, ServiceDaoException {
        return moduleService.getObjectByDynamicCondition(aClass, map, integer, integer1);
    }

    @Override
    public Object getMapListByDynamicCondition(Class aClass, Map<String, Object> map, Integer integer, Integer integer1) throws ServiceException, ServiceDaoException {
        return moduleService.getMapListByDynamicCondition(aClass, map, integer, integer1);
    }


    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return moduleService.fakeDelete(clz, id);
    }


    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        moduleService.deleteList(clz, ids);

    }
}

