/**
 *
 */
package com.ptteng.sca.employment.common.client;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.employment.common.model.CustomerManager;
import com.ptteng.employment.common.service.CustomerManagerService;
import org.osoa.sca.annotations.Reference;

import java.util.List;
import java.util.Map;

public class CustomerManagerSCAClient implements CustomerManagerService {

    private CustomerManagerService managerService;

    public CustomerManagerService getCustomerManagerService() {
        return managerService;
    }

    @Reference
    public void setCustomerManagerService(CustomerManagerService managerService) {
        this.managerService = managerService;
    }

    @Override
    public Long insert(CustomerManager manager) throws ServiceException, ServiceDaoException {

        return managerService.insert(manager);

    }

    @Override
    public List<CustomerManager> insertList(List<CustomerManager> managerList) throws ServiceException, ServiceDaoException {

        return managerService.insertList(managerList);

    }

    @Override
    public boolean delete(Long id) throws ServiceException, ServiceDaoException {

        return managerService.delete(id);

    }

    @Override
    public boolean update(CustomerManager manager) throws ServiceException, ServiceDaoException {

        return managerService.update(manager);

    }

    @Override
    public boolean updateList(List<CustomerManager> managerList) throws ServiceException, ServiceDaoException {

        return managerService.updateList(managerList);

    }

    @Override
    public CustomerManager getObjectById(Long id) throws ServiceException, ServiceDaoException {

        return managerService.getObjectById(id);

    }

    @Override
    public List<CustomerManager> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {

        return managerService.getObjectsByIds(ids);

    }

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    @Override
    public List<Long> getCustomerManagerIdsByName(String name, Integer start, Integer limit) throws ServiceException,
            ServiceDaoException {

        return managerService.getCustomerManagerIdsByName(name, start, limit);

    }

    @Override
    public List<Long> getCustomerManagerIdsByNameAndCustomerId(String name, Long customerId, Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        return managerService.getCustomerManagerIdsByNameAndCustomerId(name,customerId, start, limit);
    }

    @Override
    public List<Long> getCustomerManagerIdsByRoleID(Long roleID, Integer start, Integer limit) throws ServiceException,
            ServiceDaoException {

        return managerService.getCustomerManagerIdsByRoleID(roleID, start, limit);

    }

    @Override
    public List<Long> getCustomerManagerIdsByRoleIDAndStatus(Long roleID, String status, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {

        return managerService.getCustomerManagerIdsByRoleIDAndStatus(roleID, status, start, limit);

    }

    @Override
    public List<Long> getCustomerManagerIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return managerService.getCustomerManagerIds(start, limit);
    }

    @Override
    public Integer countCustomerManagerIds() throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return managerService.countCustomerManagerIds();
    }

    @Override
    public List<Long> getCustomerManagerIdsByCondition(Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return managerService.getCustomerManagerIdsByCondition(conditions, start, limit);
    }

    @Override
    public List<Long> getIdsByDynamicCondition(Class clz, Map<String, Object> conditions, Integer start, Integer limit)
            throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return managerService.getIdsByDynamicCondition(clz, conditions, start, limit);
    }

    @Override
    public Object getObjectByDynamicCondition(Class aClass, Map<String, Object> map, Integer integer, Integer integer1) throws ServiceException, ServiceDaoException {
        return managerService.getObjectByDynamicCondition(aClass, map, integer, integer1);
    }

    @Override
    public Object getMapListByDynamicCondition(Class aClass, Map<String, Object> map, Integer integer, Integer integer1) throws ServiceException, ServiceDaoException {
        return managerService.getMapListByDynamicCondition(aClass, map, integer, integer1);
    }

    @Override
    public boolean fakeDelete(Class clz, Long id) throws ServiceException, ServiceDaoException {
        // TODO Auto-generated method stub
        return managerService.fakeDelete(clz, id);
    }

    @Override
    public void deleteList(Class clz, List<Long> ids) throws ServiceException, ServiceDaoException {
        managerService.deleteList(clz, ids);

    }

}

