package com.ptteng.employment.common.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.employment.common.model.ServiceProvider;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface ServiceProviderService extends BaseDaoService {


    public Long insert(ServiceProvider serviceProvider) throws ServiceException, ServiceDaoException;


    public List<ServiceProvider> insertList(List<ServiceProvider> serviceProviderList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(ServiceProvider serviceProvider) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<ServiceProvider> serviceProviderList) throws ServiceException, ServiceDaoException;


    public ServiceProvider getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<ServiceProvider> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getServiceProviderIdByCreditCode(String creditCode) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getServiceProviderIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countServiceProviderIds() throws ServiceException, ServiceDaoException;


}

