package com.ptteng.employment.common.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.employment.common.model.Invoice;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface InvoiceService extends BaseDaoService {


    public Long insert(Invoice invoice) throws ServiceException, ServiceDaoException;


    public List<Invoice> insertList(List<Invoice> invoiceList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(Invoice invoice) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<Invoice> invoiceList) throws ServiceException, ServiceDaoException;


    public Invoice getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<Invoice> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countInvoiceIdsByCustomerId(Long customerId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getInvoiceIdsByCustomerId(Long customerId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getInvoiceIdsByInvoiceOrderId(Long invoiceOrderId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getInvoiceIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countInvoiceIds() throws ServiceException, ServiceDaoException;


}

