package com.ptteng.employment.common.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.employment.common.model.InvoiceOrderProject;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface InvoiceOrderProjectService extends BaseDaoService {


    public Long insert(InvoiceOrderProject invoiceOrderProject) throws ServiceException, ServiceDaoException;


    public List<InvoiceOrderProject> insertList(List<InvoiceOrderProject> invoiceOrderProjectList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(InvoiceOrderProject invoiceOrderProject) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<InvoiceOrderProject> invoiceOrderProjectList) throws ServiceException, ServiceDaoException;


    public InvoiceOrderProject getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<InvoiceOrderProject> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countInvoiceOrderProjectIdsByInvoiceOrderId(Long invoiceOrderId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getInvoiceOrderProjectIdsByInvoiceOrderId(Long invoiceOrderId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getInvoiceOrderProjectIdByProjectId(Long projectId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getInvoiceOrderProjectIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countInvoiceOrderProjectIds() throws ServiceException, ServiceDaoException;


}

