package com.ptteng.employment.common.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.employment.common.model.Dict;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface DictService extends BaseDaoService {


    public Long insert(Dict dict) throws ServiceException, ServiceDaoException;


    public List<Dict> insertList(List<Dict> dictList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(Dict dict) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<Dict> dictList) throws ServiceException, ServiceDaoException;


    public Dict getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<Dict> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countDictIdsByName(String name) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getDictIdsByName(String name, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getDictIdByNameAndType(String name, String type) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getDictIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countDictIds() throws ServiceException, ServiceDaoException;


}

