package com.ptteng.employment.common.service;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;
import com.ptteng.employment.common.model.CustomerRoleModule;
import org.osoa.sca.annotations.Remotable;

import java.util.List;

@Remotable
public interface CustomerRoleModuleService extends BaseDaoService {


    public Long insert(CustomerRoleModule roleModule) throws ServiceException, ServiceDaoException;


    public List<CustomerRoleModule> insertList(List<CustomerRoleModule> roleModuleList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(CustomerRoleModule roleModule) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<CustomerRoleModule> roleModuleList) throws ServiceException, ServiceDaoException;


    public CustomerRoleModule getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<CustomerRoleModule> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countCustomerRoleModuleIdsByRid(Long rid) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getCustomerRoleModuleIdsByRid(Long rid, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getCustomerRoleModuleIdsByMid(Long mid, Integer start, Integer limit) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getCustomerRoleModuleIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countCustomerRoleModuleIds() throws ServiceException, ServiceDaoException;


}

