package com.ptteng.employment.common.service;

import java.util.List;
import java.util.Map;

import org.osoa.sca.annotations.Remotable;

import com.ptteng.employment.common.model.Bank;
import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.ptteng.common.dao.BaseDaoService;

@Remotable
public interface BankService extends BaseDaoService {


    public Long insert(Bank bank) throws ServiceException, ServiceDaoException;


    public List<Bank> insertList(List<Bank> bankList) throws ServiceException, ServiceDaoException;


    public boolean delete(Long id) throws ServiceException, ServiceDaoException;


    public boolean update(Bank bank) throws ServiceException, ServiceDaoException;


    public boolean updateList(List<Bank> bankList) throws ServiceException, ServiceDaoException;


    public Bank getObjectById(Long id) throws ServiceException, ServiceDaoException;


    public List<Bank> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countBankIdsByUserId(Long userId) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getBankIdsByUserId(Long userId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;
    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getBankIdsByUserIdAndCustomerId(Long userId,Long customerId, Integer start, Integer limit) throws ServiceException, ServiceDaoException;
    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Long getBankIdsByUserIdAndCustomerIdAndStatus(Long userId,Long customerId,Integer status) throws ServiceException, ServiceDaoException;


    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public List<Long> getBankIds(Integer start, Integer limit)
            throws ServiceException, ServiceDaoException;

    /**
     * @param
     * @return
     * @throws ServiceException
     * @throws ServiceDaoException
     */
    public Integer countBankIds() throws ServiceException, ServiceDaoException;


}

