package com.ptteng.employment.common.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "user")
public class User implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 6454589033393853440L;


    /**
     * 停用
     */
    public static final Integer STATUS_DISABLE = 0;

    /**
     * 启用
     */
    public static final Integer STATUS_ENABLE = 1;

    /**
     * 已校验
     */
    public static final Integer STATUS_VALIDATION_YES = 1;

    /**
     * 未校验
     */
    public static final Integer STATUS_VALIDATION_NO = 0;

    /**
     * 通过校验结果
     */
    public static final String MESSAGE = "通过校验";

    /**
     * 已签约
     */
    public static final Integer STATUS_SIGNING_YES = 1;

    /**
     * 未签约
     */
    public static final Integer STATUS_SIGNING_NO = 0;

    /**
     * 已列入黑名单
     */
    public static final Integer STATUS_BLACKLIST_YES = 1;

    /**
     * 未列入黑名单
     */
    public static final Integer STATUS_BLACKLIST_NO = 0;


    /**
     * 自增长ID
     */
    private Long id;


    /**
     * 头像
     */
    private String avatar;


    /**
     * 微信 openid
     */
    private String openId;


    /**
     * 用户名
     */
    private String name;


    /**
     * 手机号
     */
    private String mobile;


    /**
     * 证件类型,1-身份证
     */
    private Integer idType;


    /**
     * 证件号码
     */
    private String idNumber;


    /**
     * 证件正面
     */
    private String idImgFront;


    /**
     * 证件背面
     */
    private String idImgBack;


    /**
     * 学历
     */
    private String qualifications;


    /**
     * 特长
     */
    private String speciality;


    /**
     * 地址
     */
    private String address;


    /**
     * 标签
     */
    private String tags;


    /**
     * 校验状态，1-已校验，0-未校验
     */
    private Integer validationStatus;


    /**
     * 签约状态，1-已签约，0-未签约
     */
    private Integer signingStatus;


    /**
     * 黑名单状态，1-黑，0-非黑
     */
    private Integer blacklistStatus;
    /**
     * 黑名单状态，1-黑，0-非黑
     */
    private Long blackListAt;


    /**
     * 可用状态，1-启用，0-停用
     */
    private Integer status;


    /**
     * 校验结果
     */
    private String validationMessage;


    /**
     * 客户id
     */
    private Long customerId;


    /**
     * 电子签名
     */
    private String electronicSignature;


    /**
     * 零客合同
     */
    private String individualSignature;


    /**
     * 完税合同
     */
    private String taxContract;


    /**
     * 创建时间
     */
    private Long createAt;


    /**
     * 更新时间
     */
    private Long updateAt;


    /**
     * 创建人
     */
    private Long createBy;


    /**
     * 更新人
     */
    private Long updateBy;

    private String bankAccount;
    /**
     * e签宝账号id
     */
    private String esignAccountId;
    /**
     * e签宝印章id
     */
    private String esignSealId;
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "avatar")
    public String getAvatar() {
        return avatar;
    }


    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    @Column(name = "open_id")
    public String getOpenId() {
        return openId;
    }


    public void setOpenId(String openId) {
        this.openId = openId;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "mobile")
    public String getMobile() {
        return mobile;
    }


    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    @Column(name = "id_type")
    public Integer getIdType() {
        return idType;
    }


    public void setIdType(Integer idType) {
        this.idType = idType;
    }

    @Column(name = "id_number")
    public String getIdNumber() {
        return idNumber;
    }


    public void setIdNumber(String idNumber) {
        this.idNumber = idNumber;
    }

    @Column(name = "id_img_front")
    public String getIdImgFront() {
        return idImgFront;
    }


    public void setIdImgFront(String idImgFront) {
        this.idImgFront = idImgFront;
    }

    @Column(name = "id_img_back")
    public String getIdImgBack() {
        return idImgBack;
    }


    public void setIdImgBack(String idImgBack) {
        this.idImgBack = idImgBack;
    }

    @Column(name = "qualifications")
    public String getQualifications() {
        return qualifications;
    }


    public void setQualifications(String qualifications) {
        this.qualifications = qualifications;
    }

    @Column(name = "speciality")
    public String getSpeciality() {
        return speciality;
    }


    public void setSpeciality(String speciality) {
        this.speciality = speciality;
    }

    @Column(name = "address")
    public String getAddress() {
        return address;
    }


    public void setAddress(String address) {
        this.address = address;
    }

    @Column(name = "tags")
    public String getTags() {
        return tags;
    }


    public void setTags(String tags) {
        this.tags = tags;
    }

    @Column(name = "validation_status")
    public Integer getValidationStatus() {
        return validationStatus;
    }


    public void setValidationStatus(Integer validationStatus) {
        this.validationStatus = validationStatus;
    }

    @Column(name = "signing_status")
    public Integer getSigningStatus() {
        return signingStatus;
    }


    public void setSigningStatus(Integer signingStatus) {
        this.signingStatus = signingStatus;
    }

    @Column(name = "blacklist_status")
    public Integer getBlacklistStatus() {
        return blacklistStatus;
    }


    public void setBlacklistStatus(Integer blacklistStatus) {
        this.blacklistStatus = blacklistStatus;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }


    @Column(name = "validation_message")
    public String getValidationMessage() {
        return validationMessage;
    }


    public void setValidationMessage(String validationMessage) {
        this.validationMessage = validationMessage;
    }

    @Column(name = "customer_id")
    public Long getCustomerId() {
        return customerId;
    }


    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    @Column(name = "electronic_signature")
    public String getElectronicSignature() {
        return electronicSignature;
    }


    public void setElectronicSignature(String electronicSignature) {
        this.electronicSignature = electronicSignature;
    }

    @Column(name = "individual_signature")
    public String getIndividualSignature() {
        return individualSignature;
    }


    public void setIndividualSignature(String individualSignature) {
        this.individualSignature = individualSignature;
    }

    @Column(name = "tax_contract")
    public String getTaxContract() {
        return taxContract;
    }


    public void setTaxContract(String taxContract) {
        this.taxContract = taxContract;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Transient
    public String getBankAccount() {
        return bankAccount;
    }

    public void setBankAccount(String bankAccount) {
        this.bankAccount = bankAccount;
    }
    @Column(name = "esign_account_id")
    public String getEsignAccountId() {
        return esignAccountId;
    }

    public void setEsignAccountId(String esignAccountId) {
        this.esignAccountId = esignAccountId;
    }
    @Column(name = "esign_seal_id")
    public String getEsignSealId() {
        return esignSealId;
    }

    public void setEsignSealId(String esignSealId) {
        this.esignSealId = esignSealId;
    }
    @Column(name = "black_list_at")
    public Long getBlackListAt() {
        return blackListAt;
    }

    public void setBlackListAt(Long blacklistAt) {
        this.blackListAt = blacklistAt;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

