package com.ptteng.employment.common.model;

import java.io.Serializable;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "sys_log")
public class SysLog implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 5420586995615665152L;


    /**
     * 客户
     */
    public static final String USER_TYPE_CUSTOMER = "CUSTOMER";

    /**
     * 零客
     */
    public static final String USER_TYPE_INDIVIDUAL = "INDIVIDUAL";

    /**
     * 未读
     */
    public static final Integer STATUS_UNREAD = 0;

    /**
     * 已读
     */
    public static final Integer STATUS_READ = 1;


    /**
     * 自增长ID
     */
    private Long id;


    /**
     * 日志
     */
    private String content;


    /**
     * 操作类型
     */
    private String actionType;


    /**
     * 表名
     */
    private String tbl;


    /**
     * 数据id
     */
    private Long dataId;


    /**
     * 状态
     */
    private Integer status;


    /**
     * 创建时间
     */
    private Long createAt;


    /**
     * 更新时间
     */
    private Long updateAt;


    /**
     * 创建人
     */
    private Long createBy;


    /**
     * 更新人
     */
    private Long updateBy;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "content")
    public String getContent() {
        return content;
    }


    public void setContent(String content) {
        this.content = content;
    }

    @Column(name = "action_type")
    public String getActionType() {
        return actionType;
    }


    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    @Column(name = "tbl")
    public String getTbl() {
        return tbl;
    }


    public void setTbl(String tbl) {
        this.tbl = tbl;
    }

    @Column(name = "data_id")
    public Long getDataId() {
        return dataId;
    }


    public void setDataId(Long dataId) {
        this.dataId = dataId;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

