package com.ptteng.employment.common.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;


@Entity
@Table(name = "flow")
public class Flow implements Serializable{

	/**
	 * 
	 */
	private static final long serialVersionUID = 9202469693963427840L;	
	
		
	/**
	 *  充值
	 * 
	 */
	public static final Integer TRADE_TYPE_RECHARGE = 1;
    	
	/**
	 *  收入
	 * 
	 */
	public static final Integer TRADE_TYPE_INCOME = 3;
    	
	/**
	 *  支出
	 * 
	 */
	public static final Integer TRADE_TYPE_EXPENDITURE = 2;
    	
	/**
	 *  交易开始
	 * 
	 */
	public static final Integer TRADE_STATE_START = 1;
    	
	/**
	 *  交易成功
	 * 
	 */
	public static final Integer TRADE_STATE_SUCCESS = 2;
    	
	/**
	 *  交易失败
	 * 
	 */
	public static final Integer TRADE_STATE_FAIL = 3;
	/**
	 *  辛巴达流水
	 *
	 */
	public static final String TYPE_XINBADA = "XINBADA";


   /**
   *  自增长ID
   *
   */
    private  Long id;
	
  
   /**
   *  系统支付单流水号
   *
   */
    private  String transactionId;
	
  
   /**
   *  外部支付单流水号
   *
   */
    private  String outTradeNo;
	
  
   /**
   *  系统订单号
   *
   */
    private  String orderNo;
	
  
   /**
   *  外部订单号
   *
   */
    private  String outOrderNo;
	
  
   /**
   *  交易类型
   *
   */
    private  Integer tradeType;
	
  
   /**
   *  系统交易状态
   *
   */
    private  Integer tradeState;
	
  
   /**
   *  外部状态描述
   *
   */
    private  String outTradeStateDesc;
	
  
   /**
   *  外部交易状态
   *
   */
    private  String outTradeState;
	
  
   /**
   *  交易金额
   *
   */
    private BigDecimal amount;
	
  
   /**
   *  交易完成时间
   *
   */
    private  Long successTime;
	
  
   /**
   *  备注
   *
   */
    private  String tradeMark;
	
  
   /**
   *  项目id
   *
   */
    private  Long projectId;
	
  
   /**
   *  发起方账户名
   *
   */
    private  String sourceAccountName;
	
  
   /**
   *  发起方系统id
   *
   */
    private  Long sourceId;
	
  
   /**
   *  发起方账户号
   *
   */
    private  String sourceAccountNo;
	
  
   /**
   *  目标方账户名
   *
   */
    private  String targetAccountName;
	
  
   /**
   *  目标方系统id
   *
   */
    private  Long targetId;
	
  
   /**
   *  目标方账户号
   *
   */
    private  String targetAccountNo;
	
  
   /**
   *  类型
   *
   */
    private  String type;
	
  
   /**
   *  创建时间
   *
   */
    private  Long createAt;
	
  
   /**
   *  更新时间
   *
   */
    private  Long updateAt;
	
  
   /**
   *  创建人
   *
   */
    private  Long createBy;
	
  
   /**
   *  更新人
   *
   */
    private  Long updateBy;
	
  
	
		 	
         	 	   @Id
     	   @GeneratedValue(strategy = GenerationType.AUTO)
              	@Column(name = "id")
	public Long getId() {
		return id;
	}
	
	
	public void setId(Long id) {
		this.id = id;
	}
		 	@Column(name = "transaction_id")
	public String getTransactionId() {
		return transactionId;
	}
	
	
	public void setTransactionId(String transactionId) {
		this.transactionId = transactionId;
	}
		 	@Column(name = "out_trade_no")
	public String getOutTradeNo() {
		return outTradeNo;
	}
	
	
	public void setOutTradeNo(String outTradeNo) {
		this.outTradeNo = outTradeNo;
	}
		 	@Column(name = "order_no")
	public String getOrderNo() {
		return orderNo;
	}
	
	
	public void setOrderNo(String orderNo) {
		this.orderNo = orderNo;
	}
		 	@Column(name = "out_order_no")
	public String getOutOrderNo() {
		return outOrderNo;
	}
	
	
	public void setOutOrderNo(String outOrderNo) {
		this.outOrderNo = outOrderNo;
	}
		 	@Column(name = "trade_type")
	public Integer getTradeType() {
		return tradeType;
	}
	
	
	public void setTradeType(Integer tradeType) {
		this.tradeType = tradeType;
	}
		 	@Column(name = "trade_state")
	public Integer getTradeState() {
		return tradeState;
	}
	
	
	public void setTradeState(Integer tradeState) {
		this.tradeState = tradeState;
	}
		 	@Column(name = "out_trade_state_desc")
	public String getOutTradeStateDesc() {
		return outTradeStateDesc;
	}
	
	
	public void setOutTradeStateDesc(String outTradeStateDesc) {
		this.outTradeStateDesc = outTradeStateDesc;
	}
		 	@Column(name = "out_trade_state")
	public String getOutTradeState() {
		return outTradeState;
	}
	
	
	public void setOutTradeState(String outTradeState) {
		this.outTradeState = outTradeState;
	}
		 	@Column(name = "amount")
	public BigDecimal getAmount() {
		return amount;
	}
	
	
	public void setAmount(BigDecimal amount) {
		this.amount = amount;
	}
		 	@Column(name = "success_time")
	public Long getSuccessTime() {
		return successTime;
	}
	
	
	public void setSuccessTime(Long successTime) {
		this.successTime = successTime;
	}
		 	@Column(name = "trade_mark")
	public String getTradeMark() {
		return tradeMark;
	}
	
	
	public void setTradeMark(String tradeMark) {
		this.tradeMark = tradeMark;
	}
		 	@Column(name = "project_id")
	public Long getProjectId() {
		return projectId;
	}
	
	
	public void setProjectId(Long projectId) {
		this.projectId = projectId;
	}
		 	@Column(name = "source_account_name")
	public String getSourceAccountName() {
		return sourceAccountName;
	}
	
	
	public void setSourceAccountName(String sourceAccountName) {
		this.sourceAccountName = sourceAccountName;
	}
		 	@Column(name = "source_id")
	public Long getSourceId() {
		return sourceId;
	}
	
	
	public void setSourceId(Long sourceId) {
		this.sourceId = sourceId;
	}
		 	@Column(name = "source_account_no")
	public String getSourceAccountNo() {
		return sourceAccountNo;
	}
	
	
	public void setSourceAccountNo(String sourceAccountNo) {
		this.sourceAccountNo = sourceAccountNo;
	}
		 	@Column(name = "target_account_name")
	public String getTargetAccountName() {
		return targetAccountName;
	}
	
	
	public void setTargetAccountName(String targetAccountName) {
		this.targetAccountName = targetAccountName;
	}
		 	@Column(name = "target_id")
	public Long getTargetId() {
		return targetId;
	}
	
	
	public void setTargetId(Long targetId) {
		this.targetId = targetId;
	}
		 	@Column(name = "target_account_no")
	public String getTargetAccountNo() {
		return targetAccountNo;
	}
	
	
	public void setTargetAccountNo(String targetAccountNo) {
		this.targetAccountNo = targetAccountNo;
	}
		 	@Column(name = "type")
	public String getType() {
		return type;
	}
	
	
	public void setType(String type) {
		this.type = type;
	}
		 	@Column(name = "create_at")
	public Long getCreateAt() {
		return createAt;
	}
	
	
	public void setCreateAt(Long createAt) {
		this.createAt = createAt;
	}
		 	@Column(name = "update_at")
	public Long getUpdateAt() {
		return updateAt;
	}
	
	
	public void setUpdateAt(Long updateAt) {
		this.updateAt = updateAt;
	}
		 	@Column(name = "create_by")
	public Long getCreateBy() {
		return createBy;
	}
	
	
	public void setCreateBy(Long createBy) {
		this.createBy = createBy;
	}
		 	@Column(name = "update_by")
	public Long getUpdateBy() {
		return updateBy;
	}
	
	
	public void setUpdateBy(Long updateBy) {
		this.updateBy = updateBy;
	}
		
	public String toString() {
		return ToStringBuilder.reflectionToString(this,
				ToStringStyle.MULTI_LINE_STYLE);
	}
	public static Integer OutTradeStateToTradeStateByXinbada(String outTradeState) {
        //待校验= 0，校验中=1，校验失败=-1，校验通过待付款=2，付款成功=30， 下发成功=50，下发失败=-10
        if ("30".equals(outTradeState) || "50".equals(outTradeState)||"-10".equals(outTradeState)) {
            //付款成功
            return Flow.TRADE_STATE_SUCCESS;
        } else if ("-1".equals(outTradeState)) {
            //付款失败
            return Flow.TRADE_STATE_FAIL;
        } else {
            //薪八达付款处理中
            return Flow.TRADE_STATE_START;
        }
    }
}

