package com.ptteng.employment.common.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;


@Entity
@Table(name = "agent_service_relation")
public class AgentServiceRelation implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 7172938989755236352L;


    /**
     * 内扣
     */
    public static final Integer BILLING_MODEL_IN = 1;

    /**
     * 外扣
     */
    public static final Integer BILLING_MODEL_OUT = 2;


    /**
     * 自增长ID
     */
    private Long id;


    /**
     * 服务商名
     */
    private String serviceProviderName;


    /**
     * 服务商id
     */
    private Long serviceProviderId;


    /**
     * 归属代理商
     */
    private Long agentProviderId;


    /**
     * 服务类型
     */
    private Integer serviceType;


    /**
     * 计费模式
     */
    private String rate;


    /**
     * 计费方式
     */
    private Integer billingMode;


    /**
     * 创建时间
     */
    private Long createAt;


    /**
     * 更新时间
     */
    private Long updateAt;


    /**
     * 创建人
     */
    private Long createBy;


    /**
     * 更新人
     */
    private Long updateBy;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "service_provider_name")
    public String getServiceProviderName() {
        return serviceProviderName;
    }


    public void setServiceProviderName(String serviceProviderName) {
        this.serviceProviderName = serviceProviderName;
    }

    @Column(name = "service_provider_id")
    public Long getServiceProviderId() {
        return serviceProviderId;
    }


    public void setServiceProviderId(Long serviceProviderId) {
        this.serviceProviderId = serviceProviderId;
    }

    @Column(name = "agent_provider_id")
    public Long getAgentProviderId() {
        return agentProviderId;
    }


    public void setAgentProviderId(Long agentProviderId) {
        this.agentProviderId = agentProviderId;
    }

    @Column(name = "service_type")
    public Integer getServiceType() {
        return serviceType;
    }


    public void setServiceType(Integer serviceType) {
        this.serviceType = serviceType;
    }

    @Column(name = "rate")
    public String getRate() {
        return rate;
    }


    public void setRate(String rate) {
        this.rate = rate;
    }

    @Column(name = "billing_mode")
    public Integer getBillingMode() {
        return billingMode;
    }


    public void setBillingMode(Integer billingMode) {
        this.billingMode = billingMode;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

