package com.ptteng.credit.user.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;


@Entity
@Table(name = "user")
public class User implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 3959746753228235776L;

    /**
     * 用户是否订阅该公众号标识，值为0时，代表此用户没有关注该公众号，拉取不到其余信息。
     */

    public static final String NOT_FOLLOW = "0";

    /**
     * 用户状态：解冻
     */
    public static final Integer STATUS_OFF = 1;

    /**
     * 用户状态：冻结
     */
    public static final Integer STATUS_ON = 0;

    /**
     * 初始化
     */
    public static final Integer INIT = 0;

    /**
     * 生成工号
     */
    public static final Integer JOB_NUMBER_TYPE = 1;

    /**
     * 生成编号
     */
    public static final Integer NUMBER_TYPE = 2;

    /**
     * 生成邀请代理单号
     */
    public static final Integer AGENT_NUMBER = 3;

    /**
     * 用户身份 实习专员
     */
    public static final Integer INTERN = 1;

    /**
     * 用户身份 业务员
     */
    public static final Integer SALESMAN = 2;

    /**
     * 用户身份 经理
     */
    public static final Integer MANAGER = 3;

    /**
     * 用户身份 银行家
     */
    public static final Integer BANKER = 4;

    /**
     * 用户身份 普通用户
     */
    public static final Integer GENERAL = 5;

    /**
     * 用户身份 实习专员
     */
    public static final int INTERN_INT = 1;

    /**
     * 用户身份 业务员
     */
    public static final int SALESMAN_INT = 2;

    /**
     * 用户身份 经理
     */
    public static final int MANAGER_INT = 3;

    /**
     * 用户身份 银行家
     */
    public static final int BANKER_INT = 4;

    /**
     * 用户身份 普通用户
     */
    public static final int GENERAL_INT = 5;

    /**
     * 用户身份 实习专员
     */
    public static final String INTERN_STR = "实习专员";

    /**
     * 用户身份 业务员
     */
    public static final String SALESMAN_STR = "专员";

    /**
     * 用户身份 经理
     */
    public static final String MANAGER_STR = "经理";

    /**
     * 用户身份 银行家
     */
    public static final String BANKER_STR = "银行家";

    /**
     * 用户身份 普通用户
     */
    public static final String GENERAL_STR = "普通用户";


    /**
     * 邀请代理 待授权
     */
    public static final Integer PENDING_AUTHORIZATION = 1;

    /**
     * 邀请代理 已授权
     */
    public static final Integer AUTHORIZED = 2;

    /**
     * 用户任务一选择二
     */
    public static final Integer SELECT_TWO = 1;

    /**
     * 当前用户是否是默认邀请人/专属客服    20=是
     */
    public static final Integer IS_SUPER_USER = 20;

    /**
     * 当前用户是否是默认邀请人/专属客服   10=否
     */
    public static final Integer IS_NOT_SUPER_USER = 10;



    private Long id;

    private String name = "";

    private String number = "";

    private String openID = "";

    private String jobNumber = "";


    private String mobile = "";


    private Integer position = 5;


    private String IDCard = "";


    private String WeChat = "";


    private Integer status = User.STATUS_OFF;


    private String WeChatNick = "";


    private Integer creditCardApplicationProgress = 0;


    private BigDecimal withdrawAmount = new BigDecimal("0");


    private BigDecimal undrawnAmount = new BigDecimal("0");


    private BigDecimal frozenAmount = new BigDecimal("0");


    private Long superId = 0L;


    private Long invitePeopleId = 0L;


    private Integer authorizationStatus = 0;


    private String requisitionNumber = "";


    private Integer inviteStatus = 0;


    private Long agentInviter = 0L;


    private Long authorizationAt = 0L;


    private String avatar = "";

    /**
     * 用户完成任务一类型：0=选择任务一，1=选择任务二
     */
    private Integer taskType = 0;

    /**
     * 用户微信unionid
     */
    private String unionid="";

    /**
     * 当前用户是否是默认邀请人/专属客服
     */
    private Integer isSuperUser=IS_NOT_SUPER_USER;

    private Long createAt;


    private Long updateAt;


    private Long createBy = 0L;


    private Long updateBy = 0L;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "number")
    public String getNumber() {
        return number;
    }


    public void setNumber(String number) {
        this.number = number;
    }

    @Column(name = "job_number")
    public String getJobNumber() {
        return jobNumber;
    }


    public void setJobNumber(String jobNumber) {
        this.jobNumber = jobNumber;
    }

    @Column(name = "mobile")
    public String getMobile() {
        return mobile;
    }


    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    @Column(name = "position")
    public Integer getPosition() {
        return position;
    }


    public void setPosition(Integer position) {
        this.position = position;
    }

    @Column(name = "id_card")
    public String getIDCard() {
        return IDCard;
    }


    public void setIDCard(String IDCard) {
        this.IDCard = IDCard;
    }

    @Column(name = "wechat")
    public String getWeChat() {
        return WeChat;
    }


    public void setWeChat(String WeChat) {
        this.WeChat = WeChat;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "wechat_nick")
    public String getWeChatNick() {
        return WeChatNick;
    }


    public void setWeChatNick(String WeChatNick) {
        this.WeChatNick = WeChatNick;
    }

    @Column(name = "credit_card_application_progress")
    public Integer getCreditCardApplicationProgress() {
        return creditCardApplicationProgress;
    }


    public void setCreditCardApplicationProgress(Integer creditCardApplicationProgress) {
        this.creditCardApplicationProgress = creditCardApplicationProgress;
    }

    @Column(name = "withdraw_amount")
    public BigDecimal getWithdrawAmount() {
        return withdrawAmount;
    }


    public void setWithdrawAmount(BigDecimal withdrawAmount) {
        this.withdrawAmount = withdrawAmount;
    }

    @Column(name = "undrawn_amount")
    public BigDecimal getUndrawnAmount() {
        return undrawnAmount;
    }


    public void setUndrawnAmount(BigDecimal undrawnAmount) {
        this.undrawnAmount = undrawnAmount;
    }

    @Column(name = "frozen_amount")
    public BigDecimal getFrozenAmount() {
        return frozenAmount;
    }


    public void setFrozenAmount(BigDecimal frozenAmount) {
        this.frozenAmount = frozenAmount;
    }

    @Column(name = "super_id")
    public Long getSuperId() {
        return superId;
    }


    public void setSuperId(Long superId) {
        this.superId = superId;
    }

    @Column(name = "invite_people_id")
    public Long getInvitePeopleId() {
        return invitePeopleId;
    }


    public void setInvitePeopleId(Long invitePeopleId) {
        this.invitePeopleId = invitePeopleId;
    }

    @Column(name = "authorization_status")
    public Integer getAuthorizationStatus() {
        return authorizationStatus;
    }


    public void setAuthorizationStatus(Integer authorizationStatus) {
        this.authorizationStatus = authorizationStatus;
    }

    @Column(name = "requisition_number")
    public String getRequisitionNumber() {
        return requisitionNumber;
    }


    public void setRequisitionNumber(String requisitionNumber) {
        this.requisitionNumber = requisitionNumber;
    }

    @Column(name = "invite_status")
    public Integer getInviteStatus() {
        return inviteStatus;
    }


    public void setInviteStatus(Integer inviteStatus) {
        this.inviteStatus = inviteStatus;
    }

    @Column(name = "agent_inviter")
    public Long getAgentInviter() {
        return agentInviter;
    }


    public void setAgentInviter(Long agentInviter) {
        this.agentInviter = agentInviter;
    }

    @Column(name = "authorization_at")
    public Long getAuthorizationAt() {
        return authorizationAt;
    }


    public void setAuthorizationAt(Long authorizationAt) {
        this.authorizationAt = authorizationAt;
    }

    @Column(name = "avatar")
    public String getAvatar() {
        return avatar;
    }


    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "open_id")
    public String getOpenID() {
        return openID;
    }

    public void setOpenID(String openID) {
        this.openID = openID;
    }

    @Column(name = "task_type")
    public Integer getTaskType() {
        return taskType;
    }

    public void setTaskType(Integer taskType) {
        this.taskType = taskType;
    }

    @Column(name = "unionid")
    public String getUnionid() {
        return unionid;
    }

    public void setUnionid(String unionid) {
        this.unionid = unionid;
    }

    @Column(name = "is_super_user")
    public Integer getIsSuperUser() {
        return isSuperUser;
    }

    public void setIsSuperUser(Integer isSuperUser) {
        this.isSuperUser = isSuperUser;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

