package com.ptteng.credit.user.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name = "commission_management")
public class CommissionManagement implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 2519587664952378368L;

    /**
     * 下架
     */
    public  static final  int NOT_SHELF=2;
    /**
     * 上架
     */
    public  static final  int SHELF=1;

    /**
     * 百分百
     */
    public static final Integer ONE_HUNDRED_PERCENT = 100;

    private Long id;

    /**
     * 普通用户分成百分比
     */
    private Integer generalUserProportion;


    /**
     * 实习专员分成百分比
     */
    private Integer internCommissionerProportion;


    /**
     *专员分成百分比
     */
    private Integer commissionerProportion;


    /**
     * 经理分成百分比
     */
    private Integer managerProportion;


    /**
     * 银行家分成百分比
     */
    private Integer bankerProportion;


    /**
     * 平台分成百分比
     */
    private Integer platformProportion;


    private Integer status = 0;


    private Long createAt;


    private Long updateAt;


    private Long createBy = 0L;


    private Long updateBy = 0L;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "general_user_proportion")
    public Integer getGeneralUserProportion() {
        return generalUserProportion;
    }


    public void setGeneralUserProportion(Integer generalUserProportion) {
        this.generalUserProportion = generalUserProportion;
    }

    @Column(name = "intern_commissioner_proportion")
    public Integer getInternCommissionerProportion() {
        return internCommissionerProportion;
    }


    public void setInternCommissionerProportion(Integer internCommissionerProportion) {
        this.internCommissionerProportion = internCommissionerProportion;
    }

    @Column(name = "commissioner_proportion")
    public Integer getCommissionerProportion() {
        return commissionerProportion;
    }


    public void setCommissionerProportion(Integer commissionerProportion) {
        this.commissionerProportion = commissionerProportion;
    }

    @Column(name = "manager_proportion")
    public Integer getManagerProportion() {
        return managerProportion;
    }


    public void setManagerProportion(Integer managerProportion) {
        this.managerProportion = managerProportion;
    }

    @Column(name = "banker_proportion")
    public Integer getBankerProportion() {
        return bankerProportion;
    }


    public void setBankerProportion(Integer bankerProportion) {
        this.bankerProportion = bankerProportion;
    }

    @Column(name = "platform_proportion")
    public Integer getPlatformProportion() {
        return platformProportion;
    }


    public void setPlatformProportion(Integer platformProportion) {
        this.platformProportion = platformProportion;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

