package com.ptteng.credit.user.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 信用卡申请表
 */
@Entity
@Table(name = "user_credit_card_application")
public class UserCreditCardApplication implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 2381181911813019648L;

    /**
     * 申请状态 待在查  （申请中）
     */
    public static final Integer STAYING_IN_CHECK = 1;

    /**
     * 申请状态 已完成
     */
    public static final Integer COMPLETED = 2;

    /**
     * 申请状态 未通过
     */
    public static final Integer DID_NOT_PASS = 3;

    /**
     * 审核状态 人工审核
     */
    public static final Integer MANUAL_REVIEW = 4;

    /**
     * 申请状态 初始化 （申请中）
     */
    public static final Integer INIT = 0;

    /**
     * 0=查全部
     */
    public static final int ALL = 0;

    /**
     * 2=已完成
     */
    public static final int COMPLETED_INT = 2;

    /**
     * 1=待在查
     */
    public static final int STAYING_IN_CHECK_INT = 1;

    /**
     * ，3=未通过
     */
    public static final int DID_NOT_PASS_INT = 3;

    /**
     * 一天时间戳
     */
    public static final Long DAY = 24 * 60 * 60 * 1000L;

    private Long id;


    private Long uid;


    private String name;


    private String mobile;

    private Long bankId;

    private String bankName;


    private String IDCard;


    private Integer status = 0;

    private Integer superStatus = 0;


    private Long createAt;


    private Long updateAt;


    private Long createBy = 0L;


    private Long updateBy = 0L;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "uid")
    public Long getUid() {
        return uid;
    }


    public void setUid(Long uid) {
        this.uid = uid;
    }

    @Column(name = "name")
    public String getName() {
        return name;
    }


    public void setName(String name) {
        this.name = name;
    }

    @Column(name = "mobile")
    public String getMobile() {
        return mobile;
    }


    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    @Column(name = "bank_id")
    public Long getBankId() {
        return bankId;
    }


    public void setBankId(Long bankId) {
        this.bankId = bankId;
    }

    @Column(name = "id_card")
    public String getIDCard() {
        return IDCard;
    }


    public void setIDCard(String IDCard) {
        this.IDCard = IDCard;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "bank_name")
    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    @Column(name = "super_status")
    public Integer getSuperStatus() {
        return superStatus;
    }

    public void setSuperStatus(Integer superStatus) {
        this.superStatus = superStatus;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

