package com.ptteng.credit.user.model;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.persistence.*;
import java.io.Serializable;
import java.math.BigDecimal;


@Entity
@Table(name = "commission_record")
public class CommissionRecord implements Serializable {

    /**
     *  提成记录表
     */
    private static final long serialVersionUID = 6872223801240569856L;

    /**
     * 提成成功
     */
    public static final Integer SUCCESS = 0;

    /**
     * 提成失败
     */
    public static final Integer FAIL = 1;


    private Long id;


    private String serialNumber;


    private Long uid;


    /**
     * 推广奖励
     */
    private BigDecimal promotionReward;


    /**
     * 应得奖励
     */
    private BigDecimal deservedReward;


    private Integer status;


    private Long bankId;

    private String bankName;

    /**
     * 提成百分比
     */
    private Integer commissionProportion;

    private Long createAt;


    private Long updateAt;


    private Long createBy = 0L;


    private Long updateBy = 0L;


    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "id")
    public Long getId() {
        return id;
    }


    public void setId(Long id) {
        this.id = id;
    }

    @Column(name = "serial_number")
    public String getSerialNumber() {
        return serialNumber;
    }


    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    @Column(name = "uid")
    public Long getUid() {
        return uid;
    }


    public void setUid(Long uid) {
        this.uid = uid;
    }

    @Column(name = "promotion_reward")
    public BigDecimal getPromotionReward() {
        return promotionReward;
    }


    public void setPromotionReward(BigDecimal promotionReward) {
        this.promotionReward = promotionReward;
    }

    @Column(name = "deserved_reward")
    public BigDecimal getDeservedReward() {
        return deservedReward;
    }


    public void setDeservedReward(BigDecimal deservedReward) {
        this.deservedReward = deservedReward;
    }

    @Column(name = "status")
    public Integer getStatus() {
        return status;
    }


    public void setStatus(Integer status) {
        this.status = status;
    }

    @Column(name = "bank_id")
    public Long getBankId() {
        return bankId;
    }


    public void setBankId(Long bankId) {
        this.bankId = bankId;
    }

    @Column(name = "create_at")
    public Long getCreateAt() {
        return createAt;
    }


    public void setCreateAt(Long createAt) {
        this.createAt = createAt;
    }

    @Column(name = "update_at")
    public Long getUpdateAt() {
        return updateAt;
    }


    public void setUpdateAt(Long updateAt) {
        this.updateAt = updateAt;
    }

    @Column(name = "create_by")
    public Long getCreateBy() {
        return createBy;
    }


    public void setCreateBy(Long createBy) {
        this.createBy = createBy;
    }

    @Column(name = "update_by")
    public Long getUpdateBy() {
        return updateBy;
    }


    public void setUpdateBy(Long updateBy) {
        this.updateBy = updateBy;
    }

    @Column(name = "bank_name")
    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    @Column(name = "commission_proportion")
    public Integer getCommissionProportion() {
        return commissionProportion;
    }

    public void setCommissionProportion(Integer commissionProportion) {
        this.commissionProportion = commissionProportion;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this,
                ToStringStyle.MULTI_LINE_STYLE);
    }

}

