/*
 * Decompiled with CFR 0.152.
 */
package com.ptteng.carrots.bangbang.service.impl;

import com.gemantic.common.exception.ServiceDaoException;
import com.gemantic.common.exception.ServiceException;
import com.gemantic.dal.dao.exception.DaoException;
import com.ptteng.carrots.bangbang.model.Profession;
import com.ptteng.carrots.bangbang.service.ProfessionService;
import com.ptteng.common.dao.BaseDaoServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProfessionServiceImpl
extends BaseDaoServiceImpl
implements ProfessionService {
    private static final Log log = LogFactory.getLog(ProfessionServiceImpl.class);

    public Long insert(Profession profession) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert data : " + profession));
        if (profession == null) {
            return null;
        }
        long currentTimeMillis = System.currentTimeMillis();
        profession.setCreateAt(Long.valueOf(currentTimeMillis));
        profession.setUpdateAt(Long.valueOf(currentTimeMillis));
        Long result = null;
        try {
            result = (Long)this.dao.save((Object)profession);
        }
        catch (DaoException e) {
            log.error((Object)(" insert wrong : " + profession));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert data success : " + result));
        return result;
    }

    public List<Profession> insertList(List<Profession> professionList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" insert lists : " + (professionList == null ? "null" : Integer.valueOf(professionList.size()))));
        List resultList = null;
        if (CollectionUtils.isEmpty(professionList)) {
            return new ArrayList<Profession>();
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Profession profession : professionList) {
            profession.setCreateAt(Long.valueOf(currentTimeMillis));
            profession.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            resultList = this.dao.batchSave(professionList);
        }
        catch (DaoException e) {
            log.error((Object)(" insert list wrong : " + professionList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" insert lists  success : " + (resultList == null ? "null" : Integer.valueOf(resultList.size()))));
        return resultList;
    }

    public boolean delete(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" delete data : " + id));
        boolean result = false;
        if (id == null) {
            return true;
        }
        try {
            result = this.dao.delete(Profession.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" delete wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" delete data success : " + id));
        return result;
    }

    public boolean update(Profession profession) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update data : " + (profession == null ? "null" : profession.getId())));
        boolean result = false;
        if (profession == null) {
            return true;
        }
        profession.setUpdateAt(Long.valueOf(System.currentTimeMillis()));
        try {
            result = this.dao.update((Object)profession);
        }
        catch (DaoException e) {
            log.error((Object)(" update wrong : " + profession));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" update data success : " + profession));
        }
        return result;
    }

    public boolean updateList(List<Profession> professionList) throws ServiceException, ServiceDaoException {
        log.info((Object)(" update lists : " + (professionList == null ? "null" : Integer.valueOf(professionList.size()))));
        boolean result = false;
        if (CollectionUtils.isEmpty(professionList)) {
            return true;
        }
        long currentTimeMillis = System.currentTimeMillis();
        for (Profession profession : professionList) {
            profession.setUpdateAt(Long.valueOf(currentTimeMillis));
        }
        try {
            result = this.dao.batchUpdate(professionList);
        }
        catch (DaoException e) {
            log.error((Object)(" update list wrong : " + professionList));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" update lists success : " + professionList.size()));
        return result;
    }

    public Profession getObjectById(Long id) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get data : " + id));
        Profession profession = null;
        if (id == null) {
            return profession;
        }
        try {
            profession = (Profession)this.dao.get(Profession.class, (Serializable)id);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + id));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + id));
        return profession;
    }

    public List<Profession> getObjectsByIds(List<Long> ids) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get lists : " + (ids == null ? "null" : ids)));
        List profession = null;
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<Profession>();
        }
        try {
            profession = this.dao.getList(Profession.class, ids);
        }
        catch (DaoException e) {
            log.error((Object)(" get wrong : " + ids));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        log.info((Object)(" get data success : " + (profession == null ? "null" : Integer.valueOf(profession.size()))));
        return profession;
    }

    public List<Long> getProfessionIds(Integer start, Integer limit) throws ServiceException, ServiceDaoException {
        log.info((Object)(" get ids   by start,limit  ================== " + start + " , " + limit));
        List idList = null;
        if (start == null) {
            start = 0;
        }
        if (limit == null) {
            limit = Integer.MAX_VALUE;
        }
        try {
            idList = this.dao.getIdList("getProfessionIdsAll", new Object[0], start, limit, false);
        }
        catch (DaoException e) {
            log.error((Object)(" get ids  wrong by start,limit)  : " + start + " , " + limit));
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" get ids success == : " + (idList == null ? "null" : Integer.valueOf(idList.size()))));
        }
        return idList;
    }

    public Integer countProfessionIds() throws ServiceException, ServiceDaoException {
        Integer count = 0;
        try {
            count = this.dao.count("getProfessionIdsAll", new Object[0]);
        }
        catch (DaoException e) {
            log.error((Object)" count by getProfessionIds ");
            log.error((Object)e);
            e.printStackTrace();
            throw new ServiceDaoException((Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)(" count  : " + count));
        }
        return count;
    }
}

