/*
 * Decompiled with CFR 0.152.
 */
package com.pszymczyk.consul;

import com.pszymczyk.consul.ConsulLogHandler;
import com.pszymczyk.consul.ConsulPorts;
import com.pszymczyk.consul.ConsulProcess;
import com.pszymczyk.consul.EmbeddedConsulException;
import com.pszymczyk.consul.LogLevel;
import com.pszymczyk.consul.infrastructure.AntUnzip;
import com.pszymczyk.consul.infrastructure.ConsulWaiter;
import com.pszymczyk.consul.infrastructure.HttpBinaryRepository;
import com.pszymczyk.consul.infrastructure.OsResolver;
import groovy.json.JsonParserType;
import groovy.json.JsonSlurper;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.Socket;
import java.nio.file.Path;
import java.util.Random;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulStarter
implements GroovyObject {
    private static final Logger logger;
    private static final Random random;
    private final Path dataDir;
    private final Path downloadDir;
    private final Path configDir;
    private final String customConfig;
    private final Object decodedCustomConfig;
    private final String consulVersion;
    private final LogLevel logLevel;
    private final Logger customLogger;
    private final ConsulPorts consulPorts;
    private final String startJoin;
    private final String advertise;
    private final String client;
    private final String bind;
    private final ConsulLogHandler logHandler;
    private boolean started;
    private HttpBinaryRepository binaryRepository;
    private AntUnzip unzip;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    /*
     * WARNING - void declaration
     */
    ConsulStarter(Path path, Path path2, Path path3, String string, String string2, LogLevel logLevel, Logger logger, ConsulPorts.ConsulPortsBuilder consulPortsBuilder, String string3, String string4, String string5, String string6) {
        void bind;
        void client;
        void advertise;
        void startJoin;
        void ports;
        void consulVersion;
        void downloadDir;
        void dataDir;
        Object object;
        Object object2;
        void customConfig;
        void configDir;
        void customLogger;
        void logLevel2;
        MetaClass metaClass;
        boolean bl;
        CallSite[] callSiteArray = ConsulStarter.$getCallSiteArray();
        this.started = bl = false;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var16_16 = logLevel2;
        this.logLevel = (LogLevel)ShortTypeHandling.castToEnum((Object)var16_16, LogLevel.class);
        void var17_17 = customLogger;
        this.customLogger = (Logger)ScriptBytecodeAdapter.castToType((Object)var17_17, Logger.class);
        void var18_18 = configDir;
        this.configDir = (Path)ScriptBytecodeAdapter.castToType((Object)var18_18, Path.class);
        void var19_19 = customConfig;
        this.customConfig = ShortTypeHandling.castToString((Object)var19_19);
        this.decodedCustomConfig = BytecodeInterface8.disabledStandardMetaClass() ? (object2 = callSiteArray[0].callStatic(ConsulStarter.class, (Object)customConfig)) : (object = ConsulStarter.parseCustomConfig((String)customConfig));
        void var22_22 = dataDir;
        this.dataDir = (Path)ScriptBytecodeAdapter.castToType((Object)var22_22, Path.class);
        void var23_23 = downloadDir;
        this.downloadDir = (Path)ScriptBytecodeAdapter.castToType((Object)var23_23, Path.class);
        void var24_24 = consulVersion;
        this.consulVersion = ShortTypeHandling.castToString((Object)var24_24);
        Object object3 = callSiteArray[1].callCurrent((GroovyObject)this, (Object)ports);
        this.consulPorts = (ConsulPorts)ScriptBytecodeAdapter.castToType((Object)object3, ConsulPorts.class);
        void var26_26 = startJoin;
        this.startJoin = ShortTypeHandling.castToString((Object)var26_26);
        void var27_27 = advertise;
        this.advertise = ShortTypeHandling.castToString((Object)var27_27);
        void var28_28 = client;
        this.client = ShortTypeHandling.castToString((Object)var28_28);
        void var29_29 = bind;
        this.bind = ShortTypeHandling.castToString((Object)var29_29);
        if (BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[2].callCurrent((GroovyObject)this);
        } else {
            this.makeDI();
        }
        Object object4 = callSiteArray[3].callConstructor(ConsulLogHandler.class, (Object)customLogger);
        this.logHandler = (ConsulLogHandler)ScriptBytecodeAdapter.castToType((Object)object4, ConsulLogHandler.class);
    }

    private ConsulPorts mergePorts(ConsulPorts.ConsulPortsBuilder ports) {
        Reference ports2 = new Reference((Object)ports);
        CallSite[] callSiteArray = ConsulStarter.$getCallSiteArray();
        Object extraPorts = callSiteArray[4].call(this.decodedCustomConfig, (Object)"ports");
        public class _mergePorts_closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference ports;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _mergePorts_closure1(Object _outerInstance, Object _thisObject, Reference ports) {
                Reference reference;
                CallSite[] callSiteArray = _mergePorts_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.ports = reference = ports;
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _mergePorts_closure1.$getCallSiteArray();
                Object object = callSiteArray[0].callGetProperty(it);
                if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"dns")) {
                    Object object2 = callSiteArray[1].call(this.ports.get(), callSiteArray[2].callGetProperty(it));
                    this.ports.set((Object)((ConsulPorts.ConsulPortsBuilder)ScriptBytecodeAdapter.castToType((Object)object2, ConsulPorts.ConsulPortsBuilder.class)));
                    return object2;
                }
                if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"http")) {
                    Object object3 = callSiteArray[3].call(this.ports.get(), callSiteArray[4].callGetProperty(it));
                    this.ports.set((Object)((ConsulPorts.ConsulPortsBuilder)ScriptBytecodeAdapter.castToType((Object)object3, ConsulPorts.ConsulPortsBuilder.class)));
                    return object3;
                }
                if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"serf_lan")) {
                    Object object4 = callSiteArray[5].call(this.ports.get(), callSiteArray[6].callGetProperty(it));
                    this.ports.set((Object)((ConsulPorts.ConsulPortsBuilder)ScriptBytecodeAdapter.castToType((Object)object4, ConsulPorts.ConsulPortsBuilder.class)));
                    return object4;
                }
                if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"serf_wan")) {
                    Object object5 = callSiteArray[7].call(this.ports.get(), callSiteArray[8].callGetProperty(it));
                    this.ports.set((Object)((ConsulPorts.ConsulPortsBuilder)ScriptBytecodeAdapter.castToType((Object)object5, ConsulPorts.ConsulPortsBuilder.class)));
                    return object5;
                }
                if (ScriptBytecodeAdapter.isCase((Object)object, (Object)"server")) {
                    Object object6 = callSiteArray[9].call(this.ports.get(), callSiteArray[10].callGetProperty(it));
                    this.ports.set((Object)((ConsulPorts.ConsulPortsBuilder)ScriptBytecodeAdapter.castToType((Object)object6, ConsulPorts.ConsulPortsBuilder.class)));
                    return object6;
                }
                return null;
            }

            public ConsulPorts.ConsulPortsBuilder getPorts() {
                CallSite[] callSiteArray = _mergePorts_closure1.$getCallSiteArray();
                return (ConsulPorts.ConsulPortsBuilder)ScriptBytecodeAdapter.castToType((Object)this.ports.get(), ConsulPorts.ConsulPortsBuilder.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _mergePorts_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "key";
                stringArray[1] = "withDnsPort";
                stringArray[2] = "value";
                stringArray[3] = "withHttpPort";
                stringArray[4] = "value";
                stringArray[5] = "withSerfLanPort";
                stringArray[6] = "value";
                stringArray[7] = "withSerfWanPort";
                stringArray[8] = "value";
                stringArray[9] = "withServerPort";
                stringArray[10] = "value";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[11];
                _mergePorts_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_mergePorts_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _mergePorts_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[5].call(extraPorts, (Object)new _mergePorts_closure1(this, this, ports2));
        return (ConsulPorts)ScriptBytecodeAdapter.castToType((Object)callSiteArray[6].call((Object)((ConsulPorts.ConsulPortsBuilder)ports2.get())), ConsulPorts.class);
    }

    private static Object parseCustomConfig(String customConfig) {
        CallSite[] callSiteArray = ConsulStarter.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)customConfig, null) || DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[7].call((Object)customConfig))) {
            return ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        }
        Object parser = callSiteArray[8].call(callSiteArray[9].callConstructor(JsonSlurper.class), callSiteArray[10].callGetProperty(JsonParserType.class));
        return callSiteArray[11].call(parser, (Object)customConfig);
    }

    private void makeDI() {
        CallSite[] callSiteArray = ConsulStarter.$getCallSiteArray();
        Object object = callSiteArray[12].callConstructor(HttpBinaryRepository.class);
        this.binaryRepository = (HttpBinaryRepository)ScriptBytecodeAdapter.castToType((Object)object, HttpBinaryRepository.class);
        Object object2 = callSiteArray[13].callConstructor(AntUnzip.class);
        this.unzip = (AntUnzip)ScriptBytecodeAdapter.castToType((Object)object2, AntUnzip.class);
    }

    public ConsulProcess start() {
        boolean bl;
        CallSite[] callSiteArray = ConsulStarter.$getCallSiteArray();
        callSiteArray[14].call((Object)logger, (Object)"Starting new Consul process.");
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[15].callCurrent((GroovyObject)this);
        } else {
            this.checkInitialState();
        }
        this.started = bl = true;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[16].callCurrent((GroovyObject)this))) {
                callSiteArray[17].callCurrent((GroovyObject)this);
            }
        } else if (!this.isBinaryDownloaded()) {
            this.downloadAndUnpackBinary();
        }
        callSiteArray[18].callCurrent((GroovyObject)this, (Object)this.consulPorts);
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)this.customConfig, null)) {
                callSiteArray[19].callCurrent((GroovyObject)this);
            }
        } else if (ScriptBytecodeAdapter.compareNotEqual((Object)this.customConfig, null)) {
            this.createExtraConfigFile();
        }
        String downloadDirAsString = ShortTypeHandling.castToString((Object)callSiteArray[20].call(callSiteArray[21].call((Object)this.downloadDir)));
        String pathToConsul = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{downloadDirAsString}, new String[]{"", "/consul"}));
        if (ScriptBytecodeAdapter.compareEqual((Object)"windows", (Object)callSiteArray[22].call(OsResolver.class))) {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{downloadDirAsString}, new String[]{"", "/consul.exe"});
            pathToConsul = ShortTypeHandling.castToString((Object)gStringImpl);
        }
        String[] command = new String[]{pathToConsul, "agent", ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.dataDir}, new String[]{"-data-dir=", ""})), "-dev", ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.configDir}, new String[]{"-config-dir=", ""})), ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.advertise}, new String[]{"-advertise=", ""})), ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.client}, new String[]{"-client=", ""})), ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[23].callGetProperty((Object)this.logLevel)}, new String[]{"-log-level=", ""})), ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[24].callGetProperty((Object)this.consulPorts)}, new String[]{"-http-port=", ""}))};
        if (ScriptBytecodeAdapter.compareNotEqual((Object)this.bind, null)) {
            command = (String[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[25].call((Object)command, (Object)new GStringImpl(new Object[]{this.bind}, new String[]{"-bind=", ""})), String[].class);
        }
        if (ScriptBytecodeAdapter.compareNotEqual((Object)this.startJoin, null)) {
            command = (String[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[26].call((Object)command, (Object)new GStringImpl(new Object[]{this.startJoin}, new String[]{"-join=", ""})), String[].class);
        }
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[27].call(this.decodedCustomConfig, (Object)"node_id"), null)) {
                command = (String[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[28].call((Object)command, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[29].call((Object)"-node-id=", callSiteArray[30].callStatic(ConsulStarter.class))})), String[].class);
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[31].call(this.decodedCustomConfig, (Object)"node_id"), null)) {
            command = (String[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[32].call((Object)command, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[33].call((Object)"-node-id=", (Object)ConsulStarter.randomNodeId())})), String[].class);
        }
        if (!BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[34].call(this.decodedCustomConfig, (Object)"node_name"), null)) {
                command = (String[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[35].call((Object)command, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[36].call((Object)"-node=", callSiteArray[37].callStatic(ConsulStarter.class))})), String[].class);
            }
        } else if (ScriptBytecodeAdapter.compareEqual((Object)callSiteArray[38].call(this.decodedCustomConfig, (Object)"node_name"), null)) {
            command = (String[])ScriptBytecodeAdapter.castToType((Object)callSiteArray[39].call((Object)command, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{callSiteArray[40].call((Object)"-node=", (Object)ConsulStarter.randomNodeName())})), String[].class);
        }
        Process innerProcess = (Process)ScriptBytecodeAdapter.castToType((Object)callSiteArray[41].call(callSiteArray[42].call(callSiteArray[43].call(callSiteArray[44].call(callSiteArray[45].call(callSiteArray[46].callConstructor(ProcessBuilder.class), callSiteArray[47].call((Object)this.downloadDir)), (Object)command)), callSiteArray[48].callGetProperty(ProcessBuilder.Redirect.class))), Process.class);
        callSiteArray[49].call((Object)this.logHandler, callSiteArray[50].call((Object)innerProcess));
        ConsulProcess process = (ConsulProcess)ScriptBytecodeAdapter.castToType((Object)callSiteArray[51].callConstructor(ConsulProcess.class, (Object)this.dataDir, (Object)this.consulPorts, (Object)this.advertise, (Object)innerProcess), ConsulProcess.class);
        callSiteArray[52].call((Object)logger, (Object)"Starting Consul process on port {}", callSiteArray[53].callGetProperty((Object)this.consulPorts));
        callSiteArray[54].call(callSiteArray[55].callConstructor(ConsulWaiter.class, (Object)this.advertise, callSiteArray[56].callGetProperty((Object)this.consulPorts)));
        callSiteArray[57].call((Object)logger, (Object)"Consul process started");
        return process;
    }

    private void checkInitialState() {
        CallSite[] callSiteArray = ConsulStarter.$getCallSiteArray();
        if (this.started) {
            throw (Throwable)callSiteArray[58].callConstructor(EmbeddedConsulException.class, (Object)"This Consul Starter instance already started Consul process. Create new ConsulStarter instance");
        }
        try {
            public class _checkInitialState_closure2
            extends Closure
            implements GeneratedClosure {
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _checkInitialState_closure2(Object _outerInstance, Object _thisObject) {
                    CallSite[] callSiteArray = _checkInitialState_closure2.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _checkInitialState_closure2.$getCallSiteArray();
                    throw (Throwable)callSiteArray[0].callConstructor(EmbeddedConsulException.class, (Object)new GStringImpl(new Object[]{callSiteArray[1].callGetProperty(callSiteArray[2].callGroovyObjectGetProperty((Object)this))}, new String[]{"Port ", " is not available, cannot start Consul process."}));
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _checkInitialState_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "<$constructor$>";
                    stringArray[1] = "httpPort";
                    stringArray[2] = "consulPorts";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[3];
                    _checkInitialState_closure2.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_checkInitialState_closure2.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _checkInitialState_closure2.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[59].call(IOGroovyMethods.class, callSiteArray[60].callConstructor(Socket.class, (Object)"localhost", callSiteArray[61].callGetProperty((Object)this.consulPorts)), (Object)new _checkInitialState_closure2(this, this));
        }
        catch (IOException ex) {
        }
    }

    private void downloadAndUnpackBinary() {
        CallSite[] callSiteArray = ConsulStarter.$getCallSiteArray();
        File file = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[62].callConstructor(File.class, callSiteArray[63].call(callSiteArray[64].call((Object)this.downloadDir)), (Object)"consul.zip"), File.class);
        callSiteArray[65].call((Object)logger, (Object)"Downloading archives into: {}", callSiteArray[66].call((Object)file));
        File archive = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[67].call((Object)this.binaryRepository, (Object)this.consulVersion, (Object)file), File.class);
        callSiteArray[68].call((Object)logger, (Object)"Unzipping binaries into: {}", callSiteArray[69].call((Object)this.downloadDir));
        callSiteArray[70].call((Object)this.unzip, (Object)archive, callSiteArray[71].call((Object)this.downloadDir));
    }

    private void createBasicConfigFile(ConsulPorts consulPorts) {
        CallSite[] callSiteArray = ConsulStarter.$getCallSiteArray();
        File portsConfigFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[72].callConstructor(File.class, callSiteArray[73].call((Object)this.configDir), (Object)"basic_config.json"), File.class);
        callSiteArray[74].call((Object)logger, (Object)"Creating ports configuration file: {}", callSiteArray[75].call((Object)portsConfigFile));
        GStringImpl gStringImpl = new GStringImpl(new Object[]{callSiteArray[76].callGetProperty((Object)consulPorts), callSiteArray[77].callGetProperty((Object)consulPorts), callSiteArray[78].callGetProperty((Object)consulPorts), callSiteArray[79].callGetProperty((Object)consulPorts)}, new String[]{"\n            {\n                \"ports\": {\n                    \"dns\": ", ",\n                    \"serf_lan\": ", ",\n                    \"serf_wan\": ", ",\n                    \"server\": ", "\n                },\n                \"disable_update_check\": true,\n                \"performance\": {\n                    \"raft_multiplier\": 1\n                }\n            }\n        "});
        ScriptBytecodeAdapter.setProperty((Object)gStringImpl, null, (Object)portsConfigFile, (String)"text");
    }

    private void createExtraConfigFile() {
        CallSite[] callSiteArray = ConsulStarter.$getCallSiteArray();
        File customConfigFile = (File)ScriptBytecodeAdapter.castToType((Object)callSiteArray[80].callConstructor(File.class, callSiteArray[81].call((Object)this.configDir), (Object)"extra_config.json"), File.class);
        callSiteArray[82].call((Object)logger, (Object)"Creating custom configuration file: {}", callSiteArray[83].call((Object)customConfigFile));
        String string = this.customConfig;
        ScriptBytecodeAdapter.setProperty((Object)string, null, (Object)customConfigFile, (String)"text");
    }

    private boolean isBinaryDownloaded() {
        CallSite[] callSiteArray = ConsulStarter.$getCallSiteArray();
        return DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[84].call(callSiteArray[85].callConstructor(File.class, callSiteArray[86].call((Object)this.downloadDir), (Object)"consul")));
    }

    private static String randomNodeId() {
        CallSite[] callSiteArray = ConsulStarter.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ShortTypeHandling.castToString((Object)callSiteArray[87].call(callSiteArray[88].call(callSiteArray[89].call(callSiteArray[90].call(callSiteArray[91].call(callSiteArray[92].call(callSiteArray[93].call(callSiteArray[94].call(callSiteArray[95].callStatic(ConsulStarter.class, (Object)8), (Object)"-"), callSiteArray[96].callStatic(ConsulStarter.class, (Object)4)), (Object)"-"), callSiteArray[97].callStatic(ConsulStarter.class, (Object)4)), (Object)"-"), callSiteArray[98].callStatic(ConsulStarter.class, (Object)4)), (Object)"-"), callSiteArray[99].callStatic(ConsulStarter.class, (Object)12)));
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[100].call(callSiteArray[101].call(callSiteArray[102].call(callSiteArray[103].call(callSiteArray[104].call(callSiteArray[105].call(callSiteArray[106].call(callSiteArray[107].call((Object)ConsulStarter.randomHex(8), (Object)"-"), (Object)ConsulStarter.randomHex(4)), (Object)"-"), (Object)ConsulStarter.randomHex(4)), (Object)"-"), (Object)ConsulStarter.randomHex(4)), (Object)"-"), (Object)ConsulStarter.randomHex(12)));
    }

    private static String randomNodeName() {
        CallSite[] callSiteArray = ConsulStarter.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ShortTypeHandling.castToString((Object)callSiteArray[108].call((Object)"node-", callSiteArray[109].callStatic(ConsulStarter.class, (Object)10)));
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[110].call((Object)"node-", (Object)ConsulStarter.randomHex(10)));
    }

    private static String randomHex(int len) {
        CallSite[] callSiteArray = ConsulStarter.$getCallSiteArray();
        StringBuilder sb = (StringBuilder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[111].callConstructor(StringBuilder.class), StringBuilder.class);
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            int i = 0;
            while (i < len) {
                callSiteArray[112].call((Object)sb, callSiteArray[113].call(Long.class, callSiteArray[114].call((Object)random, (Object)16)));
                int n = i;
                i = DefaultTypeTransformation.intUnbox((Object)callSiteArray[115].call((Object)n));
            }
        } else {
            int i = 0;
            while (i < len) {
                callSiteArray[116].call((Object)sb, callSiteArray[117].call(Long.class, callSiteArray[118].call((Object)random, (Object)16)));
                int n = i;
                int cfr_ignored_0 = n + 1;
            }
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[119].call((Object)sb));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ConsulStarter.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Object object = ConsulStarter.$getCallSiteArray()[120].call(LoggerFactory.class, ConsulStarter.class);
        logger = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
        Object object2 = ConsulStarter.$getCallSiteArray()[121].callConstructor(Random.class);
        random = (Random)ScriptBytecodeAdapter.castToType((Object)object2, Random.class);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "parseCustomConfig";
        stringArray[1] = "mergePorts";
        stringArray[2] = "makeDI";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "getAt";
        stringArray[5] = "collect";
        stringArray[6] = "build";
        stringArray[7] = "isEmpty";
        stringArray[8] = "setType";
        stringArray[9] = "<$constructor$>";
        stringArray[10] = "LAX";
        stringArray[11] = "parseText";
        stringArray[12] = "<$constructor$>";
        stringArray[13] = "<$constructor$>";
        stringArray[14] = "info";
        stringArray[15] = "checkInitialState";
        stringArray[16] = "isBinaryDownloaded";
        stringArray[17] = "downloadAndUnpackBinary";
        stringArray[18] = "createBasicConfigFile";
        stringArray[19] = "createExtraConfigFile";
        stringArray[20] = "toString";
        stringArray[21] = "toAbsolutePath";
        stringArray[22] = "resolve";
        stringArray[23] = "value";
        stringArray[24] = "httpPort";
        stringArray[25] = "plus";
        stringArray[26] = "plus";
        stringArray[27] = "getAt";
        stringArray[28] = "plus";
        stringArray[29] = "plus";
        stringArray[30] = "randomNodeId";
        stringArray[31] = "getAt";
        stringArray[32] = "plus";
        stringArray[33] = "plus";
        stringArray[34] = "getAt";
        stringArray[35] = "plus";
        stringArray[36] = "plus";
        stringArray[37] = "randomNodeName";
        stringArray[38] = "getAt";
        stringArray[39] = "plus";
        stringArray[40] = "plus";
        stringArray[41] = "start";
        stringArray[42] = "redirectOutput";
        stringArray[43] = "inheritIO";
        stringArray[44] = "command";
        stringArray[45] = "directory";
        stringArray[46] = "<$constructor$>";
        stringArray[47] = "toFile";
        stringArray[48] = "PIPE";
        stringArray[49] = "handleStream";
        stringArray[50] = "getInputStream";
        stringArray[51] = "<$constructor$>";
        stringArray[52] = "info";
        stringArray[53] = "httpPort";
        stringArray[54] = "awaitUntilConsulStarted";
        stringArray[55] = "<$constructor$>";
        stringArray[56] = "httpPort";
        stringArray[57] = "info";
        stringArray[58] = "<$constructor$>";
        stringArray[59] = "withCloseable";
        stringArray[60] = "<$constructor$>";
        stringArray[61] = "httpPort";
        stringArray[62] = "<$constructor$>";
        stringArray[63] = "toString";
        stringArray[64] = "toAbsolutePath";
        stringArray[65] = "info";
        stringArray[66] = "toString";
        stringArray[67] = "getConsulBinaryArchive";
        stringArray[68] = "info";
        stringArray[69] = "toString";
        stringArray[70] = "unzip";
        stringArray[71] = "toFile";
        stringArray[72] = "<$constructor$>";
        stringArray[73] = "toFile";
        stringArray[74] = "info";
        stringArray[75] = "toString";
        stringArray[76] = "dnsPort";
        stringArray[77] = "serfLanPort";
        stringArray[78] = "serfWanPort";
        stringArray[79] = "serverPort";
        stringArray[80] = "<$constructor$>";
        stringArray[81] = "toFile";
        stringArray[82] = "info";
        stringArray[83] = "toString";
        stringArray[84] = "exists";
        stringArray[85] = "<$constructor$>";
        stringArray[86] = "toString";
        stringArray[87] = "plus";
        stringArray[88] = "plus";
        stringArray[89] = "plus";
        stringArray[90] = "plus";
        stringArray[91] = "plus";
        stringArray[92] = "plus";
        stringArray[93] = "plus";
        stringArray[94] = "plus";
        stringArray[95] = "randomHex";
        stringArray[96] = "randomHex";
        stringArray[97] = "randomHex";
        stringArray[98] = "randomHex";
        stringArray[99] = "randomHex";
        stringArray[100] = "plus";
        stringArray[101] = "plus";
        stringArray[102] = "plus";
        stringArray[103] = "plus";
        stringArray[104] = "plus";
        stringArray[105] = "plus";
        stringArray[106] = "plus";
        stringArray[107] = "plus";
        stringArray[108] = "plus";
        stringArray[109] = "randomHex";
        stringArray[110] = "plus";
        stringArray[111] = "<$constructor$>";
        stringArray[112] = "append";
        stringArray[113] = "toHexString";
        stringArray[114] = "nextInt";
        stringArray[115] = "next";
        stringArray[116] = "append";
        stringArray[117] = "toHexString";
        stringArray[118] = "nextInt";
        stringArray[119] = "toString";
        stringArray[120] = "getLogger";
        stringArray[121] = "<$constructor$>";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[122];
        ConsulStarter.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ConsulStarter.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ConsulStarter.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

