/*
 * Decompiled with CFR 0.152.
 */
package com.piggsoft.beetl.spring.boot.autoconfigue;

import com.piggsoft.beetl.spring.boot.autoconfigue.BeetlProperties;
import java.util.List;
import java.util.Map;
import org.beetl.core.ErrorHandler;
import org.beetl.core.Format;
import org.beetl.core.Function;
import org.beetl.core.ResourceLoader;
import org.beetl.core.TagFactory;
import org.beetl.core.VirtualAttributeEval;
import org.beetl.core.VirtualClassAttribute;
import org.beetl.core.resource.ClasspathResourceLoader;
import org.beetl.ext.spring.BeetlGroupUtilConfiguration;
import org.beetl.ext.spring.BeetlSpringViewResolver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={BeetlProperties.class})
public class BeetlAutoConfiguration {
    @Autowired
    private BeetlProperties properties;
    @Autowired(required=false)
    @Qualifier(value="beetlFunctions")
    private Map<String, Function> functions = null;
    @Autowired(required=false)
    @Qualifier(value="beetlTypeFormats")
    private Map<Class<?>, Format> typeFormats = null;
    @Autowired(required=false)
    @Qualifier(value="beetlFormats")
    private Map<String, Format> formats = null;
    @Autowired(required=false)
    @Qualifier(value="beetlTagFactorys")
    private Map<String, TagFactory> tagFactorys = null;
    @Autowired(required=false)
    @Qualifier(value="beetlFunctionPackages")
    private Map<String, Object> functionPackages = null;
    @Autowired(required=false)
    @Qualifier(value="beetlVirtualClassAttributes")
    private Map<Class<?>, VirtualClassAttribute> virtualClassAttributes = null;
    @Autowired(required=false)
    @Qualifier(value="beetlVirtualAttributeEvals")
    private List<VirtualAttributeEval> virtualAttributeEvals = null;
    @Autowired(required=false)
    @Qualifier(value="beetlErrorHandler")
    protected ErrorHandler errorHandler = null;
    @Autowired(required=false)
    @Qualifier(value="beetlSharedVars")
    protected Map<String, Object> sharedVars = null;

    @Bean(initMethod="init", name={"beetlConfig"})
    public BeetlGroupUtilConfiguration getBeetlGroupUtilConfiguration() {
        BeetlGroupUtilConfiguration beetlGroupUtilConfiguration = new BeetlGroupUtilConfiguration();
        try {
            ClasspathResourceLoader cploder = new ClasspathResourceLoader(BeetlAutoConfiguration.class.getClassLoader(), this.properties.getTemplatesPath());
            if (this.properties.getConfig() != null) {
                beetlGroupUtilConfiguration.setConfigProperties(this.properties.getConfig().toProperties());
            }
            if (this.functions != null) {
                beetlGroupUtilConfiguration.setFunctions(this.functions);
            }
            if (this.typeFormats != null) {
                beetlGroupUtilConfiguration.setTypeFormats(this.typeFormats);
            }
            if (this.formats != null) {
                beetlGroupUtilConfiguration.setFormats(this.formats);
            }
            if (this.tagFactorys != null) {
                beetlGroupUtilConfiguration.setTagFactorys(this.tagFactorys);
            }
            if (this.functionPackages != null) {
                beetlGroupUtilConfiguration.setFunctionPackages(this.functionPackages);
            }
            if (this.virtualClassAttributes != null) {
                beetlGroupUtilConfiguration.setVirtualClassAttributes(this.virtualClassAttributes);
            }
            if (this.virtualAttributeEvals != null) {
                beetlGroupUtilConfiguration.setVirtualAttributeEvals(this.virtualAttributeEvals);
            }
            if (this.errorHandler != null) {
                beetlGroupUtilConfiguration.setErrorHandler(this.errorHandler);
            }
            if (this.sharedVars != null) {
                beetlGroupUtilConfiguration.setSharedVars(this.sharedVars);
            }
            beetlGroupUtilConfiguration.setResourceLoader((ResourceLoader)cploder);
            return beetlGroupUtilConfiguration;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Bean(name={"beetlViewResolver"})
    public BeetlSpringViewResolver getBeetlSpringViewResolver(@Qualifier(value="beetlConfig") BeetlGroupUtilConfiguration beetlGroupUtilConfiguration) {
        BeetlSpringViewResolver beetlSpringViewResolver = new BeetlSpringViewResolver();
        beetlSpringViewResolver.setContentType("text/html;charset=UTF-8");
        beetlSpringViewResolver.setOrder(0);
        beetlSpringViewResolver.setConfig(beetlGroupUtilConfiguration);
        return beetlSpringViewResolver;
    }
}

